/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class PlayerConfigOptionValuePacket
extends PlayerConfigPacket {
    protected final PlayerConfigType type;
    protected final String subId;
    protected final UUID owner;
    protected final List<Entry> entries;

    public PlayerConfigOptionValuePacket(PlayerConfigType type, String subId, UUID owner, List<Entry> entries) {
        this.type = type;
        this.subId = subId;
        this.owner = owner;
        this.entries = entries;
    }

    public PlayerConfigType getType() {
        return this.type;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Stream<Entry> entryStream() {
        return this.entries.stream();
    }

    public int getSize() {
        return this.entries.size();
    }

    public String getSubId() {
        return this.subId;
    }

    public static final class Entry {
        private final String id;
        private final Class<?> type;
        private final Object value;
        private final boolean mutable;
        private final boolean defaulted;

        public Entry(String id, Class<?> type, Object value, boolean mutable, boolean defaulted) {
            this.id = id;
            this.type = type;
            this.value = value;
            this.mutable = mutable;
            this.defaulted = defaulted;
        }

        public String getId() {
            return this.id;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isMutable() {
            return this.mutable;
        }

        public boolean isDefaulted() {
            return this.defaulted;
        }
    }

    public static abstract class Codec<P extends PlayerConfigOptionValuePacket>
    implements BiConsumer<P, class_2540>,
    Function<class_2540, P> {
        protected abstract int getSizeLimit();

        protected abstract P create(PlayerConfigType var1, String var2, UUID var3, List<Entry> var4);

        @Override
        public P apply(class_2540 input) {
            try {
                if (input.readableBytes() > this.getSizeLimit()) {
                    return null;
                }
                class_2487 nbt = (class_2487)input.method_30616(class_2505.method_53898());
                if (nbt == null) {
                    return null;
                }
                String typeString = nbt.method_68564("t", "");
                if (typeString.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config type string is too long!");
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                String subID = nbt.method_68564("si", null);
                if (subID != null && subID.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config sub ID string is too long!");
                    return null;
                }
                UUID owner = type != PlayerConfigType.PLAYER || nbt.method_68566("co", false) ? null : (UUID)XaeroNbtUtil.getUUID(nbt, "o").orElse(null);
                class_2499 entryListTag = nbt.method_68569("e");
                if (entryListTag.size() < 0 || entryListTag.size() > 512) {
                    OpenPartiesAndClaims.LOGGER.info("Received an illegal player config option entry number: " + entryListTag.size());
                    return null;
                }
                ArrayList<Entry> entries = new ArrayList<Entry>(entryListTag.size());
                String warningToOutput = null;
                for (class_2520 e : entryListTag) {
                    Class valueType;
                    Object value;
                    class_2487 entryTag = (class_2487)e;
                    String optionId = entryTag.method_68564("i", "");
                    if (optionId.length() > 1000) {
                        OpenPartiesAndClaims.LOGGER.info("Received player config option id string is not allowed!");
                        return null;
                    }
                    if (!entryTag.method_10545("v")) {
                        value = null;
                        valueType = null;
                    } else {
                        class_2520 valueTag = entryTag.method_10580("v");
                        if (valueTag instanceof class_2481) {
                            class_2481 byteTag = (class_2481)valueTag;
                            value = byteTag.method_10698() != 0;
                            valueType = Boolean.class;
                        } else if (valueTag instanceof class_2497) {
                            class_2497 intTag = (class_2497)valueTag;
                            value = intTag.method_10701();
                            valueType = Integer.class;
                        } else if (valueTag instanceof class_2489) {
                            class_2489 doubleTag = (class_2489)valueTag;
                            value = doubleTag.method_10697();
                            valueType = Double.class;
                        } else if (valueTag instanceof class_2494) {
                            class_2494 floatTag = (class_2494)valueTag;
                            value = Float.valueOf(floatTag.method_10700());
                            valueType = Float.class;
                        } else if (valueTag instanceof class_2519) {
                            class_2519 stringTag = (class_2519)valueTag;
                            value = stringTag.comp_3831();
                            valueType = String.class;
                            if (((String)value).length() > 1000) {
                                OpenPartiesAndClaims.LOGGER.info("Received a string option value that is too long: " + ((String)value).length());
                                return null;
                            }
                        } else {
                            if (warningToOutput != null) continue;
                            warningToOutput = "Received unknown player config option value tag type: " + String.valueOf(valueTag.method_23258());
                            continue;
                        }
                    }
                    boolean mutable = entryTag.method_68566("m", false);
                    boolean defaulted = entryTag.method_68566("d", false);
                    Entry entry = new Entry(optionId, valueType, value, mutable, defaulted);
                    entries.add(entry);
                }
                if (warningToOutput != null) {
                    OpenPartiesAndClaims.LOGGER.info(warningToOutput);
                }
                return this.create(type, subID, owner, entries);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(P t, class_2540 u) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("t", ((PlayerConfigOptionValuePacket)t).getType().name());
            if (((PlayerConfigOptionValuePacket)t).subId != null) {
                nbt.method_10582("si", ((PlayerConfigOptionValuePacket)t).subId);
            }
            if (((PlayerConfigOptionValuePacket)t).getType() == PlayerConfigType.PLAYER) {
                nbt.method_10556("co", ((PlayerConfigOptionValuePacket)t).owner == null);
                if (((PlayerConfigOptionValuePacket)t).owner != null) {
                    XaeroNbtUtil.putUUID(nbt, "o", ((PlayerConfigOptionValuePacket)t).owner);
                }
            }
            class_2499 entryListTag = new class_2499();
            for (Entry entry : ((PlayerConfigOptionValuePacket)t).entries) {
                class_2487 entryTag = new class_2487();
                Object entryValue = entry.getValue();
                entryTag.method_10582("i", entry.getId());
                if (entryValue != null) {
                    if (entry.getType() == Boolean.class) {
                        entryTag.method_10556("v", ((Boolean)entryValue).booleanValue());
                    } else if (entry.getType() == Integer.class) {
                        entryTag.method_10569("v", ((Integer)entryValue).intValue());
                    } else if (entry.getType() == Double.class) {
                        entryTag.method_10549("v", ((Double)entryValue).doubleValue());
                    } else if (entry.getType() == Float.class) {
                        entryTag.method_10548("v", ((Float)entryValue).floatValue());
                    } else if (entry.getType() == String.class) {
                        entryTag.method_10582("v", (String)entryValue);
                    } else {
                        OpenPartiesAndClaims.LOGGER.info("Sending an unknown player config option type: " + String.valueOf(entry.getType()));
                    }
                }
                entryTag.method_10556("m", entry.isMutable());
                entryTag.method_10556("d", entry.isDefaulted());
                entryListTag.add((Object)entryTag);
            }
            nbt.method_10566("e", (class_2520)entryListTag);
            u.method_10794((class_2520)nbt);
        }
    }
}

