/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.api.IClientPartyAPI;
import xaero.pac.common.packet.parties.PartyPlayerInfoCodec;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyPlayerPacket
extends LazyPacket<ClientboundPartyPlayerPacket> {
    public static final Codec CODEC = new Codec(new PartyPlayerInfoCodec());
    private final Type type;
    private final Action action;
    private final IPartyPlayerInfo playerInfo;

    public ClientboundPartyPlayerPacket(Type type, Action action, IPartyPlayerInfo playerInfo) {
        this.type = type;
        this.action = action;
        this.playerInfo = playerInfo;
    }

    @Override
    protected Function<class_2540, ClientboundPartyPlayerPacket> getDecoder() {
        return CODEC;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_10582("t", this.type.toString());
        tag.method_10582("a", this.action.toString());
        class_2487 playerTag = this.type == Type.INVITE ? ClientboundPartyPlayerPacket.CODEC.playerInfoCodec.toPartyInviteTag((PartyInvite)this.playerInfo) : ClientboundPartyPlayerPacket.CODEC.playerInfoCodec.toMemberTag((PartyMember)this.playerInfo);
        tag.method_10566("pi", (class_2520)playerTag);
        u.method_10794((class_2520)tag);
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.type, this.action, this.playerInfo.getUsername()});
    }

    public static enum Type {
        MEMBER,
        INVITE,
        OWNER;

    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    protected static class Codec
    extends LazyPacket.Encoder<ClientboundPartyPlayerPacket>
    implements Function<class_2540, ClientboundPartyPlayerPacket> {
        private final PartyPlayerInfoCodec playerInfoCodec;

        public Codec(PartyPlayerInfoCodec playerInfoCodec) {
            this.playerInfoCodec = playerInfoCodec;
        }

        @Override
        public ClientboundPartyPlayerPacket apply(class_2540 input) {
            try {
                PartyInvite playerInfo;
                if (input.readableBytes() > 102400) {
                    return null;
                }
                class_2487 tag = (class_2487)input.method_30616(class_2505.method_53898());
                if (tag == null) {
                    return null;
                }
                String typeString = tag.method_68564("t", null);
                if (typeString == null || typeString.length() > 128) {
                    return null;
                }
                Type type = Type.valueOf(typeString);
                String actionString = tag.method_68564("a", null);
                if (actionString == null || actionString.length() > 128) {
                    return null;
                }
                Action action = Action.valueOf(actionString);
                class_2487 playerTag = tag.method_68568("pi");
                PartyPlayerInfo partyPlayerInfo = type == Type.INVITE ? this.playerInfoCodec.fromPartyInviteTag(playerTag) : (playerInfo = this.playerInfoCodec.fromMemberTag(playerTag, type == Type.OWNER));
                if (playerInfo == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received party player packet with invalid data.");
                    return null;
                }
                return new ClientboundPartyPlayerPacket(type, action, playerInfo);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyPlayerPacket> {
        @Override
        public void handle(ClientboundPartyPlayerPacket t) {
            IClientPartyAPI party = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty();
            if (party == null) {
                return;
            }
            if (t.type == Type.MEMBER) {
                IPartyMember memberInfo = (IPartyMember)t.playerInfo;
                if (t.action == Action.ADD) {
                    party.addMember(memberInfo.getUUID(), memberInfo.getRank(), memberInfo.getUsername());
                } else {
                    party.removeMember(memberInfo.getUUID());
                }
                if (t.action == Action.UPDATE) {
                    party.addMember(memberInfo.getUUID(), memberInfo.getRank(), memberInfo.getUsername());
                }
            } else if (t.type == Type.OWNER) {
                if (t.action != Action.UPDATE) {
                    OpenPartiesAndClaims.LOGGER.info("Received invalid party owner update packet!");
                    return;
                }
                IPartyMember newInfo = (IPartyMember)t.playerInfo;
                IPartyMemberAPI owner = party.getOwner();
                if (owner.getUUID() != newInfo.getUUID()) {
                    party.changeOwner(newInfo.getUUID(), newInfo.getUsername());
                } else {
                    ((PartyMember)party.getOwner()).setUsername(newInfo.getUsername());
                }
            } else if (t.action == Action.ADD) {
                party.invitePlayer(t.playerInfo.getUUID(), t.playerInfo.getUsername());
            } else if (t.action == Action.REMOVE) {
                party.uninvitePlayer(t.playerInfo.getUUID());
            } else {
                OpenPartiesAndClaims.LOGGER.info("Received invalid party invites update packet!");
                return;
            }
        }
    }
}

