/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.api;

import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.IOpenPACMinecraftServer;
import xaero.pac.common.server.IServerDataAPI;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.protection.api.IChunkProtectionAPI;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigManagerAPI;
import xaero.pac.common.server.player.localization.api.IAdaptiveLocalizerAPI;

public class OpenPACServerAPI {
    private final IServerDataAPI serverData;

    public OpenPACServerAPI(IServerDataAPI serverData) {
        this.serverData = serverData;
    }

    @Nonnull
    public IPartyManagerAPI getPartyManager() {
        return this.serverData.getPartyManager();
    }

    @Nonnull
    public IServerClaimsManagerAPI getServerClaimsManager() {
        return this.serverData.getServerClaimsManager();
    }

    @Nonnull
    public IPlayerConfigManagerAPI getPlayerConfigs() {
        return this.serverData.getPlayerConfigs();
    }

    public IAdaptiveLocalizerAPI getAdaptiveTextLocalizer() {
        return this.serverData.getAdaptiveLocalizer();
    }

    public IChunkProtectionAPI getChunkProtection() {
        return this.serverData.getChunkProtection();
    }

    @Nonnull
    public static OpenPACServerAPI get(@Nonnull MinecraftServer server) {
        return ((IOpenPACMinecraftServer)server).getXaero_OPAC_ServerData().getAPI();
    }
}

