/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObjectManager;
import xaero.pac.common.server.io.ObjectManagerIOManager;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.expiration.PartyExpirationHandler;
import xaero.pac.common.server.parties.party.io.PartyManagerIO;
import xaero.pac.common.server.parties.party.sync.PartySynchronizer;
import xaero.pac.common.server.parties.party.task.PartyRemovalSpreadoutTask;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.task.ServerSpreadoutQueuedTaskHandler;
import xaero.pac.common.util.linked.LinkedChain;

public final class PartyManager
implements IPartyManager<ServerParty>,
ObjectManagerIOManager<ServerParty, PartyManager>,
ObjectManagerIOExpirableObjectManager<ServerParty> {
    private final MinecraftServer server;
    private final PartySynchronizer partySynchronizer;
    private final Map<UUID, ServerParty> partiesByOwner;
    private final Map<UUID, ServerParty> partiesById;
    private final Map<UUID, ServerParty> partiesByMember;
    private final Map<UUID, Set<UUID>> partiesByAlly;
    private final LinkedChain<ServerParty> partyChain;
    private final Set<ServerParty> toSave;
    private PartyManagerIO<?> io;
    private IPlayerConfigManager playerConfigs;
    private boolean loaded;
    private PartyExpirationHandler expirationHandler;
    private final ServerSpreadoutQueuedTaskHandler<PartyRemovalSpreadoutTask> partyRemovalTaskHandler;

    private PartyManager(MinecraftServer server, PartySynchronizer partySynchronizer, Map<UUID, ServerParty> partiesByOwner, Map<UUID, ServerParty> partiesById, Map<UUID, ServerParty> partiesByMember, Map<UUID, Set<UUID>> partiesByAlly, LinkedChain<ServerParty> partyChain, Set<ServerParty> toSave, ServerSpreadoutQueuedTaskHandler<PartyRemovalSpreadoutTask> partyRemovalTaskHandler) {
        this.server = server;
        this.partySynchronizer = partySynchronizer;
        this.partiesByOwner = partiesByOwner;
        this.partiesById = partiesById;
        this.partiesByMember = partiesByMember;
        this.partiesByAlly = partiesByAlly;
        this.partyChain = partyChain;
        this.toSave = toSave;
        this.partyRemovalTaskHandler = partyRemovalTaskHandler;
    }

    public void setExpirationHandler(PartyExpirationHandler expirationHandler) {
        this.expirationHandler = expirationHandler;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void setPlayerConfigs(IPlayerConfigManager playerConfigs) {
        this.playerConfigs = playerConfigs;
    }

    @Override
    public IPlayerConfigManager getPlayerConfigs() {
        return this.playerConfigs;
    }

    public void setIo(PartyManagerIO<?> io) {
        this.io = io;
    }

    @Override
    @Nullable
    public ServerParty getPartyByOwner(@Nonnull UUID owner) {
        return this.partiesByOwner.get(owner);
    }

    @Override
    @Nullable
    public ServerParty getPartyById(@Nonnull UUID id) {
        return this.partiesById.get(id);
    }

    @Override
    @Nullable
    public ServerParty getPartyByMember(@Nonnull UUID member) {
        ServerParty result = this.partiesByMember.get(member);
        if (result != null && result.isDestroyed()) {
            return null;
        }
        return result;
    }

    private Set<UUID> getPartiesByAlly(UUID id) {
        return this.partiesByAlly.computeIfAbsent(id, i -> new HashSet());
    }

    public boolean isAlliedByAnyone(UUID id) {
        return this.partiesByAlly.containsKey(id);
    }

    @Override
    public boolean partyExistsForOwner(@Nonnull UUID owner) {
        return this.getPartyByOwner(owner) != null;
    }

    @Override
    @Nullable
    public ServerParty createPartyForOwner(@Nonnull class_1657 owner) {
        UUID createdUUID;
        if (!((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
            return null;
        }
        ServerParty existing = this.getPartyByOwner(owner.method_5667());
        if (existing != null) {
            return null;
        }
        while (this.partiesById.containsKey(createdUUID = UUID.randomUUID())) {
        }
        PartyMember ownerMember = new PartyMember(owner.method_5667(), true);
        ownerMember.setRank(PartyMemberRank.ADMIN);
        ownerMember.setUsername(owner.method_7334().name());
        ServerParty created = ServerParty.Builder.begin().setManagedBy(this).setOwner(ownerMember).setId(createdUUID).build();
        this.addParty(created);
        return created;
    }

    @Override
    public void removePartyByOwner(@Nonnull UUID owner) {
        if (!((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
            return;
        }
        this.removeTypedParty(this.getPartyByOwner(owner));
    }

    @Override
    public void removePartyById(@Nonnull UUID id) {
        if (!((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
            return;
        }
        this.removeTypedParty(this.getPartyById(id));
    }

    @Override
    public void removeTypedParty(@Nonnull ServerParty party) {
        if (!((Boolean)ServerConfig.CONFIG.partiesEnabled.get()).booleanValue()) {
            return;
        }
        if (party == null) {
            return;
        }
        UUID partyOwnerId = party.getOwner().getUUID();
        if (this.getPartyByOwner(partyOwnerId) == party) {
            this.partiesByOwner.remove(partyOwnerId);
        }
        this.partiesById.remove(party.getId());
        this.partyChain.remove(party);
        party.getOnlineMemberStream().forEach(p -> this.onMemberRemoved(party, party.getMemberInfo(p.method_5667())));
        this.onMemberRemoved(party, party.getOwner());
        this.io.delete(party);
        this.toSave.remove(party);
        this.partyRemovalTaskHandler.addTask(new PartyRemovalSpreadoutTask(this, party), ServerData.from(this.server));
    }

    public void addParty(ServerParty party) {
        party.setDirty(true);
        ServerParty currentOwnerParty = this.getPartyByOwner(party.getOwner().getUUID());
        if (currentOwnerParty != null) {
            this.removeTypedParty(currentOwnerParty);
        }
        this.partiesByOwner.put(party.getOwner().getUUID(), party);
        this.partiesById.put(party.getId(), party);
        party.getTypedMemberInfoStream().forEach(mi -> this.onMemberAdded(party, (PartyMember)mi));
        party.getTypedAllyPartiesStream().forEach(ally -> this.onAllyAdded(party, ally.getPartyId()));
        this.partyChain.add(party);
    }

    public void onAllyAdded(ServerParty party, UUID allyId) {
        if (this.loaded) {
            this.getPartySynchronizer().syncToPartyAllyAdd(party, this.getPartyById(allyId));
        }
        this.getPartiesByAlly(allyId).add(party.getId());
    }

    public void onAllyRemoved(ServerParty party, UUID allyId, boolean onPartyRemoval) {
        if (this.loaded) {
            this.getPartySynchronizer().syncToPartyAllyRemove(party, allyId, onPartyRemoval);
        }
        Set<UUID> alliers = this.getPartiesByAlly(allyId);
        alliers.remove(party.getId());
        if (alliers.isEmpty()) {
            this.partiesByAlly.remove(allyId);
        }
    }

    public void onMemberAdded(ServerParty party, PartyMember m) {
        this.partiesByMember.put(m.getUUID(), party);
        if (this.loaded) {
            this.getPartySynchronizer().syncToMember(m, party);
        }
    }

    public void onMemberRemoved(ServerParty party, PartyMember m) {
        if (this.partiesByMember.get(m.getUUID()) == party) {
            this.partiesByMember.remove(m.getUUID());
            if (this.loaded) {
                this.getPartySynchronizer().syncToMember(m, null);
            }
        }
    }

    public void onOwnerChange(PartyMember oldOwner, PartyMember newOwner) {
        this.partiesByOwner.put(newOwner.getUUID(), this.partiesByOwner.remove(oldOwner.getUUID()));
    }

    @Override
    public Iterable<ServerParty> getToSave() {
        return this.toSave;
    }

    @Override
    @Nonnull
    public Stream<ServerParty> getTypedAllStream() {
        return this.partyChain.stream();
    }

    @Override
    public Iterator<ServerParty> getExpirationIterator() {
        return this.partyChain.iterator();
    }

    @Override
    @Nonnull
    public Stream<ServerParty> getTypedPartiesThatAlly(@Nonnull UUID allyId) {
        if (this.isAlliedByAnyone(allyId)) {
            return this.getPartiesByAlly(allyId).stream().map(this::getPartyById).filter(Objects::nonNull);
        }
        return Stream.empty();
    }

    public void debug() {
        System.out.println("partiesByOwner");
        this.partiesByOwner.forEach((k, v) -> System.out.println(String.valueOf(k) + " -> " + String.valueOf(v)));
        System.out.println("");
        System.out.println("partiesById");
        this.partiesById.forEach((k, v) -> System.out.println(String.valueOf(k) + " -> " + String.valueOf(v)));
        System.out.println("");
        System.out.println("partiesByMember");
        this.partiesByMember.forEach((k, v) -> System.out.println(String.valueOf(k) + " -> " + String.valueOf(v)));
        System.out.println("");
    }

    @Override
    public void addToSave(ServerParty object) {
        this.toSave.add(object);
    }

    public PartySynchronizer getPartySynchronizer() {
        return this.partySynchronizer;
    }

    public PartyExpirationHandler getExpirationHandler() {
        return this.expirationHandler;
    }

    public static final class Builder {
        private MinecraftServer server;
        private ServerSpreadoutQueuedTaskHandler<PartyRemovalSpreadoutTask> partyRemovalTaskHandler;

        public Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setPartyRemovalTaskHandler(ServerSpreadoutQueuedTaskHandler<PartyRemovalSpreadoutTask> partyRemovalTaskHandler) {
            this.partyRemovalTaskHandler = partyRemovalTaskHandler;
            return this;
        }

        public PartyManager build() {
            if (this.server == null || this.partyRemovalTaskHandler == null) {
                throw new IllegalStateException();
            }
            PartySynchronizer partySynchronizer = PartySynchronizer.Builder.begin().setServer(this.server).build();
            PartyManager result = new PartyManager(this.server, partySynchronizer, new HashMap<UUID, ServerParty>(), new HashMap<UUID, ServerParty>(), new HashMap<UUID, ServerParty>(), new HashMap<UUID, Set<UUID>>(), new LinkedChain<ServerParty>(), new HashSet<ServerParty>(), this.partyRemovalTaskHandler);
            partySynchronizer.setPartyManager(result);
            return result;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

