/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.common.api.implementation.ApiContextSetFactory;
import me.lucko.luckperms.common.api.implementation.ApiUser;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsBuilderImpl;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextManager;
import net.luckperms.api.context.ContextSetFactory;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiContextManager
implements ContextManager {
    private final LuckPermsPlugin plugin;
    private final me.lucko.luckperms.common.context.manager.ContextManager handle;

    public ApiContextManager(LuckPermsPlugin plugin, me.lucko.luckperms.common.context.manager.ContextManager<?, ?> handle) {
        this.plugin = plugin;
        this.handle = handle;
    }

    private Object checkType(Object subject) {
        if (!this.handle.getSubjectClass().isAssignableFrom(subject.getClass())) {
            throw new IllegalStateException("Subject class " + String.valueOf(subject.getClass()) + " is not assignable from " + String.valueOf(this.handle.getSubjectClass()));
        }
        return subject;
    }

    @Override
    public @NonNull ImmutableContextSet getContext(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        return this.handle.getContext(this.checkType(subject));
    }

    @Override
    public @NonNull Optional<ImmutableContextSet> getContext(@NonNull User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getQueryOptionsForUser(ApiUser.cast(user)).map(QueryOptions::context);
    }

    @Override
    public @NonNull ImmutableContextSet getStaticContext() {
        return this.handle.getStaticContext();
    }

    @Override
    public @NonNull QueryOptions.Builder queryOptionsBuilder(@NonNull QueryMode mode) {
        Objects.requireNonNull(mode, "mode");
        return new QueryOptionsBuilderImpl(mode);
    }

    @Override
    public @NonNull QueryOptions getQueryOptions(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        return this.handle.getQueryOptions(subject);
    }

    @Override
    public @NonNull Optional<QueryOptions> getQueryOptions(@NonNull User user) {
        Objects.requireNonNull(user, "user");
        return this.plugin.getQueryOptionsForUser(ApiUser.cast(user));
    }

    @Override
    public @NonNull QueryOptions getStaticQueryOptions() {
        return this.handle.getStaticQueryOptions();
    }

    @Override
    public void registerCalculator(@NonNull ContextCalculator<?> calculator) {
        Objects.requireNonNull(calculator, "calculator");
        this.handle.registerCalculator(calculator);
    }

    @Override
    public void unregisterCalculator(@NonNull ContextCalculator<?> calculator) {
        Objects.requireNonNull(calculator, "calculator");
        this.handle.unregisterCalculator(calculator);
    }

    @Override
    public @NonNull ContextSetFactory getContextSetFactory() {
        return ApiContextSetFactory.INSTANCE;
    }

    @Override
    public void signalContextUpdate(@NonNull Object subject) {
        Objects.requireNonNull(subject, "subject");
        this.handle.signalContextUpdate(this.checkType(subject));
    }
}

