/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import me.lucko.luckperms.common.api.implementation.ApiPermissionHolder;
import me.lucko.luckperms.common.cacheddata.UserCachedDataManager;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeEqualityPredicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiUser
extends ApiPermissionHolder
implements User {
    private final me.lucko.luckperms.common.model.User handle;

    public static me.lucko.luckperms.common.model.User cast(User u) {
        Preconditions.checkState((boolean)(u instanceof ApiUser), (Object)("Illegal instance " + String.valueOf(u.getClass()) + " cannot be handled by this implementation."));
        return ((ApiUser)u).getHandle();
    }

    public ApiUser(me.lucko.luckperms.common.model.User handle) {
        super(handle);
        this.handle = handle;
    }

    @Override
    me.lucko.luckperms.common.model.User getHandle() {
        return this.handle;
    }

    @Override
    public @NonNull UUID getUniqueId() {
        return this.handle.getUniqueId();
    }

    @Override
    public String getUsername() {
        return this.handle.getUsername().orElse(null);
    }

    @Override
    public @NonNull String getPrimaryGroup() {
        String value = this.handle.getCachedData().getMetaData(this.handle.getQueryOptions()).getPrimaryGroup(CheckOrigin.LUCKPERMS_API);
        Objects.requireNonNull(value, "value");
        return value;
    }

    @Override
    public @NonNull DataMutateResult setPrimaryGroup(@NonNull String group) {
        Objects.requireNonNull(group, "group");
        if (group.equalsIgnoreCase(this.handle.getPrimaryGroup().getStoredValue().orElse(null))) {
            return DataMutateResult.FAIL_ALREADY_HAS;
        }
        if (!this.handle.hasNode(DataType.NORMAL, Inheritance.builder(group.toLowerCase(Locale.ROOT)).build(), NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE).asBoolean()) {
            return DataMutateResult.FAIL;
        }
        this.handle.getPrimaryGroup().setStoredValue(group.toLowerCase(Locale.ROOT));
        return DataMutateResult.SUCCESS;
    }

    @Override
    public @NonNull UserCachedDataManager getCachedData() {
        return this.handle.getCachedData();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUser)) {
            return false;
        }
        ApiUser that = (ApiUser)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }
}

