/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.backup;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.CompletableFutures;
import me.lucko.luckperms.common.util.Uuids;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class Importer
implements Runnable {
    private final LuckPermsPlugin plugin;
    private final Set<Sender> notify;
    private final JsonObject data;
    private final boolean merge;

    public Importer(LuckPermsPlugin plugin, Sender executor, JsonObject data, boolean merge) {
        this.plugin = plugin;
        this.notify = executor.isConsole() ? ImmutableSet.of((Object)executor) : ImmutableSet.of((Object)executor, (Object)plugin.getConsoleSender());
        this.data = data;
        this.merge = merge;
    }

    private void processGroup(String groupName, Set<Node> nodes) {
        Group group = this.plugin.getStorage().createAndLoadGroup(groupName, CreationCause.INTERNAL).join();
        if (this.merge) {
            group.mergeNodes(DataType.NORMAL, nodes);
        } else {
            group.setNodes(DataType.NORMAL, nodes, false);
        }
        this.plugin.getStorage().saveGroup(group);
    }

    private void processTrack(String trackName, List<String> groups) {
        Track track = this.plugin.getStorage().createAndLoadTrack(trackName, CreationCause.INTERNAL).join();
        track.setGroups(groups);
        this.plugin.getStorage().saveTrack(track).join();
    }

    private void processUser(UUID uuid, UserData userData) {
        User user = this.plugin.getStorage().loadUser(uuid, userData.username).join();
        if (userData.primaryGroup != null) {
            user.getPrimaryGroup().setStoredValue(userData.primaryGroup);
        }
        if (this.merge) {
            user.mergeNodes(DataType.NORMAL, userData.nodes);
        } else {
            user.setNodes(DataType.NORMAL, userData.nodes, false);
        }
        this.plugin.getStorage().saveUser(user).join();
        this.plugin.getUserManager().getHouseKeeper().cleanup(user.getUniqueId());
    }

    private Set<Map.Entry<String, JsonElement>> getDataSection(String id) {
        if (this.data.has(id)) {
            return this.data.get(id).getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private void parseExportData(Map<String, Set<Node>> groups, Map<String, List<String>> tracks, Map<UUID, UserData> users) {
        for (Map.Entry<String, JsonElement> group : this.getDataSection("groups")) {
            groups.put(group.getKey(), NodeJsonSerializer.deserializeNodes(group.getValue().getAsJsonObject().get("nodes").getAsJsonArray()));
        }
        for (Map.Entry<String, JsonElement> track : this.getDataSection("tracks")) {
            JsonArray trackGroups = track.getValue().getAsJsonObject().get("groups").getAsJsonArray();
            ArrayList trackGroupsList = new ArrayList();
            trackGroups.forEach(g -> trackGroupsList.add(g.getAsString()));
            tracks.put(track.getKey(), trackGroupsList);
        }
        for (Map.Entry<String, JsonElement> user : this.getDataSection("users")) {
            JsonObject jsonData = user.getValue().getAsJsonObject();
            UUID uuid = UUID.fromString(user.getKey());
            String username = null;
            String primaryGroup = null;
            Set<Node> nodes = NodeJsonSerializer.deserializeNodes(jsonData.get("nodes").getAsJsonArray());
            if (jsonData.has("username")) {
                username = jsonData.get("username").getAsString();
            }
            if (jsonData.has("primaryGroup")) {
                primaryGroup = jsonData.get("primaryGroup").getAsString();
            }
            users.put(uuid, new UserData(username, primaryGroup, nodes));
        }
    }

    private void parseWebEditorData(Map<String, Set<Node>> groups, Map<String, List<String>> tracks, Map<UUID, UserData> users) {
        JsonArray holdersArray = this.data.get("permissionHolders").getAsJsonArray();
        for (JsonElement holderElement : holdersArray) {
            JsonObject jsonData = holderElement.getAsJsonObject();
            HolderType type = HolderType.valueOf(jsonData.get("type").getAsString().toUpperCase(Locale.ROOT));
            String id = jsonData.get("id").getAsString();
            if (type == HolderType.GROUP) {
                groups.put(id, NodeJsonSerializer.deserializeNodes(jsonData.get("nodes").getAsJsonArray()));
                continue;
            }
            UUID uuid = UUID.fromString(id);
            String username = null;
            String displayName = jsonData.get("displayName").getAsString();
            if (!Uuids.PREDICATE.test(displayName)) {
                username = displayName;
            }
            Set<Node> nodes = NodeJsonSerializer.deserializeNodes(jsonData.get("nodes").getAsJsonArray());
            users.put(uuid, new UserData(username, null, nodes));
        }
        JsonArray tracksArray = this.data.get("tracks").getAsJsonArray();
        for (JsonElement trackElement : tracksArray) {
            JsonObject jsonData = trackElement.getAsJsonObject();
            String name = jsonData.get("id").getAsString();
            JsonArray trackGroups = jsonData.get("groups").getAsJsonArray();
            ArrayList trackGroupsList = new ArrayList();
            trackGroups.forEach(g -> trackGroupsList.add(g.getAsString()));
            tracks.put(name, trackGroupsList);
        }
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.notify.forEach(Message.IMPORT_START::send);
        CompletableFuture<Void> updateTask = CompletableFuture.runAsync(() -> this.plugin.getSyncTaskBuffer().requestDirectly());
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Reading data..."));
        HashMap<String, Set<Node>> groups = new HashMap<String, Set<Node>>();
        HashMap<String, List<String>> tracks = new HashMap<String, List<String>>();
        HashMap<UUID, UserData> users = new HashMap<UUID, UserData>();
        if (this.data.has("knownPermissions")) {
            this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "The data appears to be from a web editor upload - attempting to recover from it"));
            this.parseWebEditorData(groups, tracks, users);
        } else {
            this.parseExportData(groups, tracks, users);
        }
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Waiting for initial update task to complete..."));
        updateTask.join();
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "Setting up data processor..."));
        ExecutorService executor = Executors.newFixedThreadPool(16, new ThreadFactoryBuilder().setNameFormat("luckperms-importer-%d").build());
        HashSet<CompletionStage> futures = new HashSet<CompletionStage>();
        int total = 0;
        AtomicInteger processedCount = new AtomicInteger(0);
        for (Map.Entry group : groups.entrySet()) {
            futures.add(CompletableFuture.completedFuture(group).thenAcceptAsync(ent -> {
                this.processGroup((String)ent.getKey(), (Set)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        for (Map.Entry track : tracks.entrySet()) {
            futures.add(CompletableFuture.completedFuture(track).thenAcceptAsync(ent -> {
                this.processTrack((String)ent.getKey(), (List)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        for (Map.Entry user : users.entrySet()) {
            futures.add(CompletableFuture.completedFuture(user).thenAcceptAsync(ent -> {
                this.processUser((UUID)ent.getKey(), (UserData)ent.getValue());
                processedCount.incrementAndGet();
            }, (Executor)executor));
            ++total;
        }
        CompletableFuture<Void> overallFuture = CompletableFutures.allOf(futures);
        this.notify.forEach(s -> Message.IMPORT_INFO.send((Sender)s, "All data entries have been processed and scheduled for import - now waiting for the execution to complete."));
        while (true) {
            try {
                overallFuture.get(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                this.sendProgress(processedCount.get(), total);
                continue;
            }
            break;
        }
        executor.shutdown();
        long endTime = System.currentTimeMillis();
        double seconds = (double)(endTime - startTime) / 1000.0;
        this.notify.forEach(s -> Message.IMPORT_END_COMPLETE.send((Sender)s, seconds));
    }

    private void sendProgress(int processedCount, int total) {
        int percent = processedCount * 100 / total;
        this.notify.forEach(s -> Message.IMPORT_PROGRESS.send((Sender)s, percent, processedCount, total));
    }

    private static final class UserData {
        private final String username;
        private final String primaryGroup;
        private final Set<Node> nodes;

        UserData(String username, String primaryGroup, Set<Node> nodes) {
            this.username = username;
            this.primaryGroup = primaryGroup;
            this.nodes = nodes;
        }
    }
}

