/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateStatistics;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.action.BulkUpdateAction;
import me.lucko.luckperms.common.filter.FilterList;
import me.lucko.luckperms.common.model.HolderType;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BulkUpdate {
    private final DataType dataType;
    private final BulkUpdateAction action;
    private final FilterList<Node> filters;
    private final BulkUpdateStatistics statistics = new BulkUpdateStatistics();
    private final boolean trackStatistics;

    public BulkUpdate(DataType dataType, BulkUpdateAction action, FilterList<Node> filters, boolean trackStatistics) {
        this.dataType = dataType;
        this.action = action;
        this.filters = filters;
        this.trackStatistics = trackStatistics;
    }

    public boolean satisfiesFilters(Node node) {
        return this.filters.evaluate(node);
    }

    private Node apply(Node node) {
        if (!this.satisfiesFilters(node)) {
            return node;
        }
        Node result = this.action.apply(node);
        if (this.trackStatistics && result != node) {
            this.statistics.incrementAffectedNodes();
        }
        return result;
    }

    public @Nullable Set<Node> apply(Set<Node> nodes, HolderType holderType) {
        HashSet<Node> results = new HashSet<Node>();
        boolean change = false;
        for (Node node : nodes) {
            Node result = this.apply(node);
            if (result != node) {
                change = true;
            }
            if (result == null) continue;
            results.add(result);
        }
        if (!change) {
            return null;
        }
        if (this.trackStatistics) {
            this.statistics.incrementAffected(holderType);
        }
        return results;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public BulkUpdateAction getAction() {
        return this.action;
    }

    public FilterList<Node> getFilters() {
        return this.filters;
    }

    public boolean isTrackingStatistics() {
        return this.trackStatistics;
    }

    public BulkUpdateStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkUpdate)) {
            return false;
        }
        BulkUpdate that = (BulkUpdate)o;
        return this.getDataType() == that.getDataType() && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.getFilters(), that.getFilters());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDataType(), this.getAction(), this.getFilters(), this.isTrackingStatistics()});
    }

    public String toString() {
        return "BulkUpdate(dataType=" + String.valueOf((Object)this.getDataType()) + ", action=" + String.valueOf(this.getAction()) + ", constraints=" + String.valueOf(this.getFilters()) + ", trackStatistics=" + this.isTrackingStatistics() + ")";
    }
}

