/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateField;
import me.lucko.luckperms.common.bulkupdate.action.BulkUpdateAction;
import me.lucko.luckperms.common.bulkupdate.action.DeleteAction;
import me.lucko.luckperms.common.bulkupdate.action.UpdateAction;
import me.lucko.luckperms.common.filter.FilterField;
import me.lucko.luckperms.common.filter.sql.FilterSqlBuilder;
import net.luckperms.api.node.Node;

public class BulkUpdateSqlBuilder
extends FilterSqlBuilder<Node> {
    public void visit(BulkUpdate update) {
        this.visit(update.getAction());
        this.visit(update.getFilters());
    }

    public void visit(BulkUpdateAction action) {
        if (action instanceof UpdateAction) {
            this.visit((UpdateAction)action);
        } else if (action instanceof DeleteAction) {
            this.visit((DeleteAction)action);
        } else {
            throw new UnsupportedOperationException(action.getClass().getName());
        }
    }

    public void visit(UpdateAction action) {
        this.builder.append("UPDATE {table} SET ");
        this.visitFieldName(action.getField());
        this.builder.append("=");
        this.builder.variable(action.getNewValue());
    }

    public void visit(DeleteAction action) {
        this.builder.append("DELETE FROM {table}");
    }

    @Override
    public void visitFieldName(FilterField<Node, ?> field) {
        if (field == BulkUpdateField.PERMISSION) {
            this.builder.append("permission");
        } else if (field == BulkUpdateField.SERVER) {
            this.builder.append("server");
        } else if (field == BulkUpdateField.WORLD) {
            this.builder.append("world");
        } else {
            throw new AssertionError(field);
        }
    }
}

