/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.types.ChatMetaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetaStackAccumulator<N extends ChatMetaNode<N, ?>> {
    private final MetaStackDefinition definition;
    private final List<Entry<N>> entries;

    public MetaStackAccumulator(MetaStackDefinition definition, ChatMetaType targetType) {
        this.definition = definition;
        List<MetaStackElement> elements = definition.getElements();
        this.entries = new ArrayList<Entry<N>>(elements.size());
        for (MetaStackElement element : elements) {
            this.entries.add(new Entry(element, targetType));
        }
    }

    public void offer(N node) {
        for (Entry<N> entry : this.entries) {
            entry.offer(node);
        }
    }

    public List<N> getElements() {
        return this.entries.stream().map(Entry::getNode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String toFormattedString() {
        LinkedList<String> elements = new LinkedList<String>();
        for (Entry<N> entry : this.entries) {
            N node = entry.getNode();
            if (node == null) continue;
            elements.add(node.getMetaValue());
        }
        if (elements.isEmpty()) {
            return null;
        }
        this.definition.getDuplicateRemovalFunction().processDuplicates(elements);
        Iterator it = elements.iterator();
        if (!it.hasNext()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getStartSpacer());
        sb.append((String)it.next());
        while (it.hasNext()) {
            sb.append(this.definition.getMiddleSpacer());
            sb.append((String)it.next());
        }
        sb.append(this.definition.getEndSpacer());
        return sb.toString();
    }

    public StringResult<N> toResult() {
        StringResult<ChatMetaNode> result;
        String formatted = this.toFormattedString();
        if (formatted == null) {
            return StringResult.nullResult();
        }
        List<N> elements = this.getElements();
        switch (elements.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return StringResult.of(formatted, (ChatMetaNode)elements.get(0));
            }
        }
        Iterator<N> it = elements.iterator();
        StringResult<ChatMetaNode> root = result = StringResult.of(formatted, (ChatMetaNode)it.next());
        while (it.hasNext()) {
            StringResult<ChatMetaNode> nested = StringResult.of((ChatMetaNode)it.next());
            root.setOverriddenResult(nested);
            root = nested;
        }
        return result;
    }

    private static final class Entry<N extends ChatMetaNode<?, ?>> {
        private final MetaStackElement element;
        private final ChatMetaType type;
        private @Nullable N current = null;

        Entry(MetaStackElement element, ChatMetaType type) {
            this.element = element;
            this.type = type;
        }

        public N getNode() {
            return this.current;
        }

        public boolean offer(N node) {
            if (this.element.shouldAccumulate(this.type, (ChatMetaNode<?, ?>)node, (ChatMetaNode<?, ?>)this.current)) {
                this.current = node;
                return true;
            }
            return false;
        }
    }
}

