/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.command.abstraction;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.CompletionSupplier;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;

public class GenericParentCommand<T extends PermissionHolder>
extends ChildCommand<T> {
    private final List<GenericChildCommand> children;
    private final HolderType type;

    public GenericParentCommand(CommandSpec spec, String name, HolderType type, List<GenericChildCommand> children) {
        super(spec, name, null, Predicates.alwaysFalse());
        this.children = children;
        this.type = type;
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, T holder, ArgumentList args, String label) {
        if (args.isEmpty()) {
            this.sendUsageDetailed(sender, label);
            return;
        }
        GenericChildCommand sub = this.children.stream().filter(s -> s.getName().equalsIgnoreCase(args.get(0))).findFirst().orElse(null);
        if (sub == null) {
            Message.COMMAND_NOT_RECOGNISED.send(sender);
            return;
        }
        if (!sub.isAuthorized(sender, this.type)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        if (sub.getArgumentCheck().test((Integer)(args.size() - 1))) {
            sub.sendDetailedUsage(sender);
            return;
        }
        try {
            sub.execute(plugin, sender, (PermissionHolder)holder, args.subList(1, args.size()), label, this.type == HolderType.USER ? sub.getUserPermission() : sub.getGroupPermission());
        }
        catch (CommandException e) {
            e.handle(sender, sub);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, CompletionSupplier.startsWith(() -> this.children.stream().filter(s -> s.isAuthorized(sender, this.type)).map(s -> s.getName().toLowerCase(Locale.ROOT)))).from(1, partial -> this.children.stream().filter(s -> s.isAuthorized(sender, this.type)).filter(s -> s.getName().equalsIgnoreCase(args.get(0))).findFirst().map(cmd -> cmd.tabComplete(plugin, sender, args.subList(1, args.size()))).orElse(Collections.emptyList())).complete((List<String>)((Object)args));
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return this.children.stream().anyMatch(sc -> sc.isAuthorized(sender, this.type));
    }

    private void sendUsageDetailed(Sender sender, String label) {
        List subs = this.children.stream().filter(s -> s.isAuthorized(sender, this.type)).collect(Collectors.toList());
        if (!subs.isEmpty()) {
            switch (this.type) {
                case USER: {
                    Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format("/%s user <user> " + this.getName().toLowerCase(Locale.ROOT), label));
                    break;
                }
                case GROUP: {
                    Message.MAIN_COMMAND_USAGE_HEADER.send(sender, this.getName(), String.format("/%s group <group> " + this.getName().toLowerCase(Locale.ROOT), label));
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.type);
                }
            }
            for (GenericChildCommand s2 : subs) {
                s2.sendUsage(sender);
            }
        } else {
            Message.COMMAND_NO_PERMISSION.send(sender);
        }
    }
}

