/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import java.util.List;
import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;

public class MetaAddChatMeta
extends GenericChildCommand {
    private final ChatMetaType type;

    public static MetaAddChatMeta forPrefix() {
        return new MetaAddChatMeta(ChatMetaType.PREFIX, CommandSpec.META_ADDPREFIX, "addprefix", CommandPermission.USER_META_ADD_PREFIX, CommandPermission.GROUP_META_ADD_PREFIX);
    }

    public static MetaAddChatMeta forSuffix() {
        return new MetaAddChatMeta(ChatMetaType.SUFFIX, CommandSpec.META_ADDSUFFIX, "addsuffix", CommandPermission.USER_META_ADD_SUFFIX, CommandPermission.GROUP_META_ADD_SUFFIX);
    }

    private MetaAddChatMeta(ChatMetaType type, CommandSpec spec, String name, CommandPermission userPermission, CommandPermission groupPermission) {
        super(spec, name, userPermission, groupPermission, Predicates.inRange(0, 1));
        this.type = type;
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        int priority = args.getPriority(0);
        String meta = args.get(1);
        MutableContextSet context = args.getContextOrDefault(2, plugin);
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        DataMutateResult result = target.setNode(DataType.NORMAL, (Node)((ChatMetaNode.Builder)this.type.builder(meta, priority).withContext(context)).build(), true);
        if (result.wasSuccessful()) {
            Message.ADD_CHATMETA_SUCCESS.send(sender, target, this.type, meta, priority, context);
            LoggedAction.build().source(sender).target(target).description("meta", "add" + this.type.name().toLowerCase(Locale.ROOT), priority, meta, context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
        } else {
            Message.ALREADY_HAS_CHAT_META.send(sender, target, this.type, meta, priority, context);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(2, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

