/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.Locale;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.model.data.DataType;

public class GroupClone
extends ChildCommand<Group> {
    public GroupClone() {
        super(CommandSpec.GROUP_CLONE, "clone", CommandPermission.GROUP_CLONE, Predicates.not(1));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Group target, ArgumentList args, String label) {
        if (ArgumentPermissions.checkViewPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String newGroupName = args.get(0).toLowerCase(Locale.ROOT);
        if (!DataConstraints.GROUP_NAME_TEST.test(newGroupName)) {
            Message.GROUP_INVALID_ENTRY.send(sender, newGroupName);
            return;
        }
        Group newGroup = plugin.getStorage().createAndLoadGroup(newGroupName, CreationCause.COMMAND).join();
        if (newGroup == null) {
            Message.GROUP_LOAD_ERROR.send(sender);
            return;
        }
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), newGroup)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        newGroup.setNodes(DataType.NORMAL, target.normalData().asList(), false);
        Message.CLONE_SUCCESS.send(sender, target.getFormattedDisplayName(), newGroup.getFormattedDisplayName());
        LoggedAction.build().source(sender).target(newGroup).description("clone", target.getName()).build().submit(plugin, sender);
        StorageAssistant.save(newGroup, sender, plugin);
    }
}

