/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic.adapter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.generic.adapter.StringBasedConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileSecretConfigAdapter
extends StringBasedConfigurationAdapter {
    private static final String PREFIX = "luckperms_";
    private final LuckPermsPlugin plugin;
    private final Path directory;

    public FileSecretConfigAdapter(LuckPermsPlugin plugin, String directory) {
        this.plugin = plugin;
        this.directory = directory == null ? null : Paths.get(directory, new String[0]);
    }

    public FileSecretConfigAdapter(LuckPermsPlugin plugin) {
        this(plugin, System.getenv("LUCKPERMS_FILE_SECRET_DIRECTORY"));
    }

    @Override
    protected @Nullable String resolveValue(String path) {
        String value;
        if (this.directory == null) {
            return null;
        }
        String key = PREFIX + path.toLowerCase(Locale.ROOT).replace('-', '_').replace('.', '_');
        Path resolvedFile = this.directory.resolve(key);
        try {
            value = new String(Files.readAllBytes(resolvedFile), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        String printableValue = ConfigKeys.shouldCensorValue(path) ? "*****" : value;
        this.plugin.getLogger().info(String.format("Resolved configuration value from file secret: %s = %s", key, printableValue));
        return value;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void reload() {
    }
}

