/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.manager;

import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.context.manager.ContextManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import net.luckperms.api.query.QueryOptions;

public abstract class SimpleContextManager<S, P extends S>
extends ContextManager<S, P> {
    private final LoadingCache<S, QueryOptions> contextsCache = CaffeineFactory.newBuilder().expireAfterWrite(50L, TimeUnit.MILLISECONDS).build(this::calculate);

    protected SimpleContextManager(LuckPermsPlugin plugin, Class<S> subjectClass, Class<P> playerClass) {
        super(plugin, subjectClass, playerClass);
    }

    @Override
    public QueryOptions getQueryOptions(S subject) {
        return (QueryOptions)this.contextsCache.get(subject);
    }

    @Override
    public void invalidateCache(S subject) {
        this.contextsCache.invalidate(subject);
    }
}

