/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.extension;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.extension.Extension;
import net.luckperms.api.extension.ExtensionManager;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleExtensionManager
implements ExtensionManager,
AutoCloseable {
    private final LuckPermsPlugin plugin;
    private final Set<LoadedExtension> extensions = new HashSet<LoadedExtension>();

    public SimpleExtensionManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void close() {
        for (LoadedExtension extension : this.extensions) {
            try {
                extension.instance.unload();
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Exception unloading extension", e);
            }
        }
        this.extensions.clear();
    }

    @Override
    public void loadExtension(Extension extension) {
        if (this.extensions.stream().anyMatch(e -> e.instance.equals(extension))) {
            return;
        }
        this.plugin.getLogger().info("Loading extension: " + extension.getClass().getName());
        this.extensions.add(new LoadedExtension(extension, null));
        extension.load();
        this.plugin.getEventDispatcher().dispatchExtensionLoad(extension);
    }

    public void loadExtensions(Path directory) {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(directory);){
            stream.forEach(path -> {
                if (path.getFileName().toString().endsWith(".jar")) {
                    try {
                        this.loadExtension((Path)path);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warn("Exception loading extension from " + String.valueOf(path), e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.plugin.getLogger().warn("Exception loading extensions from " + String.valueOf(directory), e);
        }
    }

    @Override
    public @NonNull Extension loadExtension(Path path) throws IOException {
        Constructor<Extension> constructor2;
        Class<Extension> extensionClass;
        String className;
        if (this.extensions.stream().anyMatch(e -> path.equals(e.path))) {
            throw new IllegalStateException("Extension at path " + path.toString() + " already loaded.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException("No file at " + String.valueOf(path));
        }
        try (JarFile jar = new JarFile(path.toFile());){
            JarEntry extensionJarEntry = jar.getJarEntry("extension.json");
            if (extensionJarEntry == null) {
                throw new IllegalStateException("extension.json not present");
            }
            try (InputStream in = jar.getInputStream(extensionJarEntry);){
                if (in == null) {
                    throw new IllegalStateException("extension.json not present");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    boolean useParentClassLoader;
                    JsonObject parsed = GsonProvider.parser().parse((Reader)reader).getAsJsonObject();
                    className = parsed.get("class").getAsString();
                    if (parsed.has("useParentClassLoader") && (useParentClassLoader = parsed.get("useParentClassLoader").getAsBoolean())) {
                        this.plugin.getLogger().warn("Extension '" + className + "' specifies the 'useParentClassLoader' extension flag, which has been deprecated/removed. The extension will be loaded using the classloader of the LuckPerms plugin, and not the classloader of the platform, which may break functionality.");
                    }
                }
            }
        }
        if (className == null) {
            throw new IllegalArgumentException("class is null");
        }
        this.plugin.getBootstrap().getClassPathAppender().addJarToClasspath(path);
        try {
            extensionClass = Class.forName(className).asSubclass(Extension.class);
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.plugin.getLogger().info("Loading extension: " + extensionClass.getName() + " (" + path.getFileName().toString() + ")");
        Extension extension = null;
        try {
            constructor2 = extensionClass.getConstructor(LuckPerms.class);
            extension = constructor2.newInstance(this.plugin.getApiProvider());
        }
        catch (NoSuchMethodException constructor2) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e3) {
            throw new RuntimeException(e3);
        }
        if (extension == null) {
            try {
                constructor2 = extensionClass.getConstructor(new Class[0]);
                extension = constructor2.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e4) {
                throw new RuntimeException("Unable to find valid constructor in " + extensionClass.getName());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e5) {
                throw new RuntimeException(e5);
            }
        }
        this.extensions.add(new LoadedExtension(extension, path));
        extension.load();
        this.plugin.getEventDispatcher().dispatchExtensionLoad(extension);
        return extension;
    }

    @Override
    public @NonNull Collection<Extension> getLoadedExtensions() {
        return this.extensions.stream().map(e -> e.instance).collect(Collectors.toSet());
    }

    private static final class LoadedExtension {
        private final Extension instance;
        private final Path path;

        private LoadedExtension(Extension instance, Path path) {
            this.instance = instance;
            this.path = path;
        }
    }
}

