/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.filter.Filter;

public class FilterList<T>
extends ForwardingList<Filter<T, ?>> {
    private final LogicalOperator operator;
    private final List<Filter<T, ?>> filters;

    public static <T> FilterList<T> empty() {
        return new FilterList<T>(LogicalOperator.AND, ImmutableList.of());
    }

    @SafeVarargs
    public static <T> FilterList<T> and(Filter<T, ?> ... filters) {
        return new FilterList<T>(LogicalOperator.AND, ImmutableList.copyOf((Object[])filters));
    }

    @SafeVarargs
    public static <T> FilterList<T> or(Filter<T, ?> ... filters) {
        return new FilterList<T>(LogicalOperator.OR, ImmutableList.copyOf((Object[])filters));
    }

    public FilterList(LogicalOperator operator, List<Filter<T, ?>> filters) {
        this.operator = operator;
        this.filters = filters;
    }

    public LogicalOperator operator() {
        return this.operator;
    }

    protected List<Filter<T, ?>> delegate() {
        return this.filters;
    }

    public boolean evaluate(T value) {
        return this.operator.match(this.filters, value);
    }

    public String toString() {
        String operator = this.operator.name().toLowerCase(Locale.ROOT);
        return this.filters.stream().map(Filter::toString).collect(Collectors.joining(" " + operator + " "));
    }

    public static enum LogicalOperator {
        AND{

            @Override
            public <T> boolean match(List<? extends Filter<T, ?>> filters, T value) {
                return filters.stream().allMatch(filter -> filter.evaluate(value));
            }
        }
        ,
        OR{

            @Override
            public <T> boolean match(List<? extends Filter<T, ?>> filters, T value) {
                return filters.stream().anyMatch(filter -> filter.evaluate(value));
            }
        };


        public abstract <T> boolean match(List<? extends Filter<T, ?>> var1, T var2);
    }
}

