/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.inheritance;

import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.query.QueryOptions;

public class InheritanceGraphFactory {
    private final LuckPermsPlugin plugin;
    private final InheritanceGraph nonContextualGraph;
    private final InheritanceGraph defaultContextualGraph;

    public InheritanceGraphFactory(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        this.nonContextualGraph = new InheritanceGraph(plugin, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        this.defaultContextualGraph = new InheritanceGraph(plugin, QueryOptionsImpl.DEFAULT_CONTEXTUAL);
    }

    public InheritanceGraph getGraph(QueryOptions queryOptions) {
        if (queryOptions == QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL) {
            return this.nonContextualGraph;
        }
        if (queryOptions == QueryOptionsImpl.DEFAULT_CONTEXTUAL) {
            return this.defaultContextualGraph;
        }
        return new InheritanceGraph(this.plugin, queryOptions);
    }
}

