/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.lib.okhttp3.Request;
import me.lucko.luckperms.lib.okhttp3.Response;
import me.lucko.luckperms.lib.okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslationRepository {
    private static final String TRANSLATIONS_INFO_ENDPOINT = "https://metadata.luckperms.net/data/translations";
    private static final String TRANSLATIONS_DOWNLOAD_ENDPOINT = "https://metadata.luckperms.net/translation/";
    private static final long MAX_BUNDLE_SIZE = 0x100000L;
    private static final long CACHE_MAX_AGE = TimeUnit.HOURS.toMillis(23L);
    private final LuckPermsPlugin plugin;

    public TranslationRepository(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public List<LanguageInfo> getAvailableLanguages() throws IOException, UnsuccessfulRequestException {
        return this.getTranslationsMetadata().languages;
    }

    public void scheduleRefresh() {
        if (!this.plugin.getConfiguration().get(ConfigKeys.AUTO_INSTALL_TRANSLATIONS).booleanValue()) {
            return;
        }
        this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
            this.clearDirectory(this.plugin.getTranslationManager().getTranslationsDirectory(), x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            try {
                this.refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void refresh() throws Exception {
        long lastRefresh = this.readLastRefreshTime();
        long timeSinceLastRefresh = System.currentTimeMillis() - lastRefresh;
        if (timeSinceLastRefresh <= CACHE_MAX_AGE) {
            return;
        }
        MetadataResponse metadata = this.getTranslationsMetadata();
        if (timeSinceLastRefresh <= metadata.cacheMaxAge) {
            return;
        }
        this.downloadAndInstallTranslations(metadata.languages, null, true);
    }

    private void clearDirectory(Path directory, Predicate<Path> predicate) {
        try {
            Files.list(directory).filter(predicate).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void downloadAndInstallTranslations(List<LanguageInfo> languages, @Nullable Sender sender, boolean updateStatus) {
        TranslationManager manager = this.plugin.getTranslationManager();
        Path translationsDirectory = manager.getRepositoryTranslationsDirectory();
        this.clearDirectory(translationsDirectory, TranslationManager::isTranslationFile);
        for (LanguageInfo language : languages) {
            if (sender != null) {
                Message.TRANSLATIONS_INSTALLING_SPECIFIC.send(sender, language.locale().toString());
            }
            Request request = new Request.Builder().header("User-Agent", this.plugin.getBytebin().getUserAgent()).url(TRANSLATIONS_DOWNLOAD_ENDPOINT + language.id()).build();
            Path file = translationsDirectory.resolve(language.locale().toString() + ".properties");
            try {
                Response response = this.plugin.getBytebin().makeHttpRequest(request);
                try {
                    ResponseBody responseBody = response.body();
                    try {
                        if (responseBody == null) {
                            throw new IOException("No response");
                        }
                        try (LimitedInputStream inputStream = new LimitedInputStream(responseBody.byteStream(), 0x100000L);){
                            Files.copy(inputStream, file, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    finally {
                        if (responseBody == null) continue;
                        responseBody.close();
                    }
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (IOException | UnsuccessfulRequestException e) {
                if (sender == null) continue;
                Message.TRANSLATIONS_DOWNLOAD_ERROR.send(sender, language.locale().toString());
                this.plugin.getLogger().warn("Unable to download translations", e);
            }
        }
        if (updateStatus) {
            this.writeLastRefreshTime();
        }
        manager.reload();
    }

    private void writeLastRefreshTime() {
        Path statusFile = this.plugin.getTranslationManager().getRepositoryStatusFile();
        try (BufferedWriter writer = Files.newBufferedWriter(statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject status = new JsonObject();
            status.add("lastRefresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            GsonProvider.prettyPrinting().toJson((JsonElement)status, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastRefreshTime() {
        Path statusFile = this.plugin.getTranslationManager().getRepositoryStatusFile();
        if (!Files.exists(statusFile, new LinkOption[0])) return 0L;
        try (BufferedReader reader = Files.newBufferedReader(statusFile, StandardCharsets.UTF_8);){
            JsonObject status = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
            if (!status.has("lastRefresh")) return 0L;
            long l = status.get("lastRefresh").getAsLong();
            return l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private MetadataResponse getTranslationsMetadata() throws IOException, UnsuccessfulRequestException {
        JsonObject jsonResponse;
        Request request = new Request.Builder().header("User-Agent", this.plugin.getBytebin().getUserAgent()).url(TRANSLATIONS_INFO_ENDPOINT).build();
        try (Response response = this.plugin.getBytebin().makeHttpRequest(request);
             ResponseBody responseBody = response.body();){
            if (responseBody == null) {
                throw new RuntimeException("No response");
            }
            try (LimitedInputStream inputStream = new LimitedInputStream(responseBody.byteStream(), 0x100000L);
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                jsonResponse = (JsonObject)GsonProvider.normal().fromJson((Reader)reader, JsonObject.class);
            }
        }
        ArrayList<LanguageInfo> languages = new ArrayList<LanguageInfo>();
        for (Map.Entry language2 : jsonResponse.get("languages").getAsJsonObject().entrySet()) {
            languages.add(new LanguageInfo((String)language2.getKey(), ((JsonElement)language2.getValue()).getAsJsonObject()));
        }
        languages.removeIf(language -> language.progress() <= 0);
        if (languages.size() >= 100) {
            throw new IOException("More than 100 languages - cancelling download");
        }
        long cacheMaxAge = jsonResponse.get("cacheMaxAge").getAsLong();
        return new MetadataResponse(cacheMaxAge, languages);
    }

    private static final class MetadataResponse {
        private final long cacheMaxAge;
        private final List<LanguageInfo> languages;

        MetadataResponse(long cacheMaxAge, List<LanguageInfo> languages) {
            this.cacheMaxAge = cacheMaxAge;
            this.languages = languages;
        }
    }

    public static final class LanguageInfo {
        private final String id;
        private final String name;
        private final Locale locale;
        private final int progress;
        private final List<String> contributors;

        LanguageInfo(String id, JsonObject data) {
            this.id = id;
            this.name = data.get("name").getAsString();
            this.locale = Objects.requireNonNull(TranslationManager.parseLocale(data.get("localeTag").getAsString()));
            this.progress = data.get("progress").getAsInt();
            this.contributors = new ArrayList<String>();
            for (JsonElement contributor : data.get("contributors").getAsJsonArray()) {
                this.contributors.add(contributor.getAsJsonObject().get("name").getAsString());
            }
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Locale locale() {
            return this.locale;
        }

        public int progress() {
            return this.progress;
        }

        public List<String> contributors() {
            return this.contributors;
        }
    }

    private static final class LimitedInputStream
    extends FilterInputStream
    implements Closeable {
        private final long limit;
        private long count;

        public LimitedInputStream(InputStream inputStream, long limit) {
            super(inputStream);
            this.limit = limit;
        }

        private void checkLimit() throws IOException {
            if (this.count > this.limit) {
                throw new IOException("Limit exceeded");
            }
        }

        @Override
        public int read() throws IOException {
            int res = super.read();
            if (res != -1) {
                ++this.count;
                this.checkLimit();
            }
            return res;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = super.read(b, off, len);
            if (res > 0) {
                this.count += (long)res;
                this.checkLimit();
            }
            return res;
        }
    }
}

