/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;

public interface PrimaryGroupHolder {
    public String calculateValue(QueryOptions var1);

    public Optional<String> getStoredValue();

    public void setStoredValue(String var1);

    public static class ParentsByWeight
    extends Stored {
        public ParentsByWeight(User user) {
            super(user);
        }

        @Override
        public String calculateValue(QueryOptions queryOptions) {
            LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
            for (InheritanceNode node : this.user.getOwnInheritanceNodes(queryOptions)) {
                Group group = (Group)this.user.getPlugin().getGroupManager().getIfLoaded(node.getGroupName());
                if (group == null) continue;
                groups.add(group);
            }
            Group bestGroup = null;
            int best = 0;
            for (Group g : groups) {
                int weight = g.getWeight().orElse(0);
                if (bestGroup != null && weight <= best) continue;
                bestGroup = g;
                best = weight;
            }
            return bestGroup == null ? super.calculateValue(queryOptions) : bestGroup.getName();
        }
    }

    public static class AllParentsByWeight
    extends Stored {
        public AllParentsByWeight(User user) {
            super(user);
        }

        @Override
        public String calculateValue(QueryOptions queryOptions) {
            InheritanceGraph graph = this.user.getPlugin().getInheritanceGraphFactory().getGraph(queryOptions);
            Iterable<PermissionHolder> traversal = graph.traverse(this.user.getPlugin().getConfiguration().get(ConfigKeys.INHERITANCE_TRAVERSAL_ALGORITHM), true, this.user);
            for (PermissionHolder holder : traversal) {
                if (!(holder instanceof Group)) continue;
                return ((Group)holder).getName();
            }
            return super.calculateValue(queryOptions);
        }
    }

    public static class Stored
    implements PrimaryGroupHolder {
        protected final User user;
        private String value = null;

        public Stored(User user) {
            this.user = Objects.requireNonNull(user, "user");
        }

        @Override
        public String calculateValue(QueryOptions queryOptions) {
            return this.value;
        }

        @Override
        public Optional<String> getStoredValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public void setStoredValue(String value) {
            this.value = value == null || value.isEmpty() ? null : value.toLowerCase(Locale.ROOT);
        }
    }
}

