/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Objects;
import java.util.Optional;
import net.luckperms.api.track.PromotionResult;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PromotionResults {
    private PromotionResults() {
    }

    public static PromotionResult success(String groupFrom, String groupTo) {
        return new Impl(PromotionResult.Status.SUCCESS, groupFrom, groupTo);
    }

    public static PromotionResult addedToFirst(String groupTo) {
        return new Impl(PromotionResult.Status.ADDED_TO_FIRST_GROUP, null, groupTo);
    }

    public static PromotionResult malformedTrack(String groupTo) {
        return new Impl(PromotionResult.Status.MALFORMED_TRACK, null, groupTo);
    }

    public static PromotionResult endOfTrack() {
        return new Impl(PromotionResult.Status.END_OF_TRACK);
    }

    public static PromotionResult ambiguousCall() {
        return new Impl(PromotionResult.Status.AMBIGUOUS_CALL);
    }

    public static PromotionResult undefinedFailure() {
        return new Impl(PromotionResult.Status.UNDEFINED_FAILURE);
    }

    private static final class Impl
    implements PromotionResult {
        private final PromotionResult.Status status;
        private final String groupFrom;
        private final String groupTo;

        private Impl(PromotionResult.Status status, String groupFrom, String groupTo) {
            this.status = status;
            this.groupFrom = groupFrom;
            this.groupTo = groupTo;
        }

        private Impl(PromotionResult.Status status) {
            this(status, null, null);
        }

        @Override
        public @NonNull PromotionResult.Status getStatus() {
            return this.status;
        }

        @Override
        public @NonNull Optional<String> getGroupFrom() {
            return Optional.ofNullable(this.groupFrom);
        }

        @Override
        public @NonNull Optional<String> getGroupTo() {
            return Optional.ofNullable(this.groupTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Impl that = (Impl)o;
            return this.status == that.status && Objects.equals(this.groupFrom, that.groupFrom) && Objects.equals(this.groupTo, that.groupTo);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.groupFrom, this.groupTo);
        }

        public String toString() {
            return "PromotionResult(status=" + String.valueOf(this.status) + ", groupFrom='" + this.groupFrom + "', groupTo='" + this.groupTo + "')";
        }
    }
}

