/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.manager;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.model.manager.Manager;

public abstract class AbstractManager<I, C, T extends C>
implements Manager<I, C, T> {
    private final LoadingMap<I, T> objects = LoadingMap.of(this);

    @Override
    public Map<I, T> getAll() {
        return ImmutableMap.copyOf(this.objects);
    }

    @Override
    public T getOrMake(I id) {
        return this.objects.get(this.sanitizeIdentifier(id));
    }

    @Override
    public T getIfLoaded(I id) {
        return this.objects.getIfPresent(this.sanitizeIdentifier(id));
    }

    @Override
    public boolean isLoaded(I id) {
        return this.objects.containsKey(this.sanitizeIdentifier(id));
    }

    @Override
    public void unload(I id) {
        if (id != null) {
            this.objects.remove(this.sanitizeIdentifier(id));
        }
    }

    @Override
    public void retainAll(Collection<I> ids) {
        this.objects.keySet().stream().filter(g -> !ids.contains(g)).forEach(this::unload);
    }

    protected I sanitizeIdentifier(I i) {
        return i;
    }
}

