/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import me.lucko.luckperms.common.node.factory.Delimiters;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.SuffixNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Suffix
extends AbstractNode<SuffixNode, SuffixNode.Builder>
implements SuffixNode {
    public static final String NODE_KEY = "suffix";
    public static final String NODE_MARKER = "suffix.";
    private final String suffix;
    private final int priority;

    public static String key(int priority, String suffix) {
        return NODE_MARKER + priority + "." + Delimiters.escapeCharacters(suffix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String suffix, int priority) {
        return Suffix.builder().suffix(suffix).priority(priority);
    }

    public Suffix(String suffix, int priority, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(Suffix.key(priority, suffix), value, expireAt, contexts, metadata);
        this.suffix = suffix;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public @NonNull String getMetaValue() {
        return this.suffix;
    }

    @Override
    public @NonNull ChatMetaType getMetaType() {
        return ChatMetaType.SUFFIX;
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.suffix, this.priority, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.toLowerCase(Locale.ROOT).startsWith(NODE_MARKER)) {
            return null;
        }
        Iterator metaParts = Delimiters.SPLIT_BY_NODE_SEPARATOR_IN_TWO.split((CharSequence)key.substring(NODE_MARKER.length())).iterator();
        if (!metaParts.hasNext()) {
            return null;
        }
        String priority = (String)metaParts.next();
        if (!metaParts.hasNext()) {
            return null;
        }
        String value = (String)metaParts.next();
        try {
            return Suffix.builder().priority(Integer.parseInt(priority)).suffix(Delimiters.unescapeCharacters(value));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final class Builder
    extends AbstractNodeBuilder<SuffixNode, SuffixNode.Builder>
    implements SuffixNode.Builder {
        private String suffix;
        private Integer priority;

        private Builder() {
            this.suffix = null;
            this.priority = null;
        }

        public Builder(String suffix, int priority, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.suffix = suffix;
            this.priority = priority;
        }

        @Override
        public @NonNull Builder suffix(@NonNull String suffix) {
            this.suffix = Objects.requireNonNull(suffix, Suffix.NODE_KEY);
            return this;
        }

        @Override
        public @NonNull Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public @NonNull Suffix build() {
            Builder.ensureDefined(this.suffix, Suffix.NODE_KEY);
            Builder.ensureDefined(this.priority, "priority");
            return new Suffix(this.suffix, this.priority, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

