/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SchemaReader {
    private static final Pattern CREATE_TABLE_PATTERN = Pattern.compile("^CREATE TABLE [`\"']([^`\"']+)[`\"'].*");
    private static final Pattern CREATE_INDEX_PATTERN = Pattern.compile("^CREATE INDEX.* ON [`\"']([^`\"']+)[`\"'].*");

    private SchemaReader() {
    }

    public static List<String> getStatements(InputStream is) throws IOException {
        LinkedList<String> queries = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--") || line.startsWith("#")) continue;
                sb.append(line);
                if (!line.endsWith(";")) continue;
                sb.deleteCharAt(sb.length() - 1);
                String result = sb.toString().trim().replaceAll(" +", " ");
                if (!result.isEmpty()) {
                    queries.add(result);
                }
                sb = new StringBuilder();
            }
        }
        return queries;
    }

    public static String tableFromStatement(String statement) {
        Matcher table = CREATE_TABLE_PATTERN.matcher(statement);
        if (table.matches()) {
            return table.group(1).toLowerCase(Locale.ROOT);
        }
        Matcher index = CREATE_INDEX_PATTERN.matcher(statement);
        if (index.matches()) {
            return index.group(1).toLowerCase(Locale.ROOT);
        }
        throw new IllegalArgumentException("Unknown statement type: " + statement);
    }

    public static List<String> filterStatements(List<String> statements, List<String> currentTables) {
        return statements.stream().filter(statement -> !currentTables.contains(SchemaReader.tableFromStatement(statement))).collect(Collectors.toList());
    }
}

