/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import me.lucko.luckperms.common.storage.StorageMetadata;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.file.NonClosableConnection;

abstract class FlatfileConnectionFactory
implements ConnectionFactory {
    private NonClosableConnection connection;
    private final Path file;

    FlatfileConnectionFactory(Path file) {
        this.file = file;
    }

    protected abstract Connection createConnection(Path var1) throws SQLException;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        NonClosableConnection connection = this.connection;
        if (connection == null || connection.isClosed()) {
            this.connection = connection = new NonClosableConnection(this.createConnection(this.file));
        }
        return connection;
    }

    @Override
    public void shutdown() throws Exception {
        if (this.connection != null) {
            this.connection.shutdown();
        }
    }

    protected Path getWriteFile() {
        return this.file;
    }

    protected void migrateOldDatabaseFile(String oldName) {
        Path oldFile = this.getWriteFile().getParent().resolve(oldName);
        if (Files.exists(oldFile, new LinkOption[0])) {
            try {
                Files.move(oldFile, this.getWriteFile(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public StorageMetadata getMeta() {
        StorageMetadata metadata = new StorageMetadata();
        Path databaseFile = this.getWriteFile();
        if (Files.exists(databaseFile, new LinkOption[0])) {
            try {
                long length = Files.size(databaseFile);
                metadata.sizeBytes(length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return metadata;
    }
}

