/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.lucko.luckperms.common.treeview.TreeNode;
import me.lucko.luckperms.common.util.ImmutableCollectors;

public class PermissionRegistry {
    private static final Splitter DOT_SPLIT = Splitter.on((char)'.').omitEmptyStrings();
    private final TreeNode rootNode = new TreeNode();

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public List<String> rootAsList() {
        return (List)this.rootNode.makeImmutableCopy().getNodeEndings().stream().map(Map.Entry::getValue).collect(ImmutableCollectors.toList());
    }

    public void offer(String permission) {
        this.insert(permission);
    }

    public void insert(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        try {
            this.doInsert(permission);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doInsert(String permission) {
        permission = permission.toLowerCase(Locale.ROOT);
        Iterable parts = DOT_SPLIT.split((CharSequence)permission);
        TreeNode current = this.rootNode;
        for (String part : parts) {
            if ((current = current.tryInsert(part)) != null) continue;
            return;
        }
    }
}

