/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import com.google.common.collect.Range;
import java.util.Locale;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Predicates {
    private static final Predicate FALSE = new Predicate(){

        public boolean test(Object o) {
            return false;
        }

        public @NonNull Predicate and(@NonNull Predicate other) {
            return this;
        }

        public @NonNull Predicate or(@NonNull Predicate other) {
            return other;
        }

        public @NonNull Predicate negate() {
            return TRUE;
        }
    };
    private static final Predicate TRUE = new Predicate(){

        public boolean test(Object o) {
            return true;
        }

        public @NonNull Predicate and(@NonNull Predicate other) {
            return other;
        }

        public @NonNull Predicate or(@NonNull Predicate other) {
            return this;
        }

        public @NonNull Predicate negate() {
            return FALSE;
        }
    };

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static Predicate<Integer> notInRange(int start, int end) {
        Range range = Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        return value -> !range.contains((Comparable)value);
    }

    public static Predicate<Integer> inRange(int start, int end) {
        Range range = Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        return arg_0 -> ((Range)range).contains(arg_0);
    }

    public static <T> Predicate<T> not(T t) {
        return obj -> !t.equals(obj);
    }

    public static <T> Predicate<T> is(T t) {
        return t::equals;
    }

    public static Predicate<String> startsWithIgnoreCase(String prefix) {
        return string -> {
            if (string.length() < prefix.length()) {
                return false;
            }
            return string.regionMatches(true, 0, prefix, 0, prefix.length());
        };
    }

    public static Predicate<String> containsIgnoreCase(String substring) {
        return string -> {
            if (string.length() < substring.length()) {
                return false;
            }
            return string.toLowerCase(Locale.ROOT).contains(substring.toLowerCase(Locale.ROOT));
        };
    }
}

