/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.lucko.luckperms.common.util.gson.JElement;

public class JObject
implements JElement {
    private final JsonObject object = new JsonObject();

    public JsonObject toJson() {
        return this.object;
    }

    public JObject add(String key, JsonElement value) {
        this.object.add(key, value);
        return this;
    }

    public JObject add(String key, String value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, Number value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, Boolean value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, (JsonElement)new JsonPrimitive(value));
    }

    public JObject add(String key, JElement value) {
        if (value == null) {
            return this.add(key, (JsonElement)JsonNull.INSTANCE);
        }
        return this.add(key, value.toJson());
    }

    public JObject add(String key, Supplier<? extends JElement> value) {
        return this.add(key, value.get().toJson());
    }

    public JObject consume(Consumer<? super JObject> consumer) {
        consumer.accept(this);
        return this;
    }
}

