/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket.listener;

import com.google.gson.JsonObject;
import java.io.EOFException;
import java.security.PublicKey;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.webeditor.socket.SignatureAlgorithm;
import me.lucko.luckperms.common.webeditor.socket.SocketMessageType;
import me.lucko.luckperms.common.webeditor.socket.WebEditorSocket;
import me.lucko.luckperms.common.webeditor.socket.listener.HandlerChangeRequest;
import me.lucko.luckperms.common.webeditor.socket.listener.HandlerConnected;
import me.lucko.luckperms.common.webeditor.socket.listener.HandlerHello;
import me.lucko.luckperms.common.webeditor.socket.listener.HandlerPing;
import me.lucko.luckperms.lib.okhttp3.Response;
import me.lucko.luckperms.lib.okhttp3.WebSocket;
import me.lucko.luckperms.lib.okhttp3.WebSocketListener;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WebEditorSocketListener
extends WebSocketListener {
    private final WebEditorSocket socket;
    private final HandlerHello helloHandler;
    private final HandlerConnected connectedHandler;
    private final HandlerPing pingHandler;
    private final HandlerChangeRequest changeRequestHandler;
    private final CompletableFuture<Void> connectFuture = new CompletableFuture();
    private final ReentrantLock lock = new ReentrantLock();

    public WebEditorSocketListener(WebEditorSocket socket) {
        this.socket = socket;
        this.helloHandler = new HandlerHello(socket);
        this.connectedHandler = new HandlerConnected(socket);
        this.pingHandler = new HandlerPing(socket);
        this.changeRequestHandler = new HandlerChangeRequest(socket);
    }

    public void onOpen(@NonNull WebSocket webSocket, @NonNull Response response) {
        this.connectFuture.complete(null);
    }

    public void onFailure(@NonNull WebSocket webSocket, @NonNull Throwable e, Response response) {
        if (e instanceof EOFException) {
            return;
        }
        this.socket.getPlugin().getLogger().warn("Exception occurred in web socket", e);
    }

    public void onMessage(@NonNull WebSocket webSocket, @NonNull String msg) {
        this.socket.getPlugin().getBootstrap().getScheduler().executeAsync(() -> {
            this.lock.lock();
            try {
                if (this.shouldIgnoreMessages()) {
                    return;
                }
                this.handleMessageFrame(msg);
            }
            catch (Exception e) {
                this.socket.getPlugin().getLogger().warn("Exception occurred handling message from socket", e);
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public boolean shouldIgnoreMessages() {
        if (this.socket.isClosed()) {
            return true;
        }
        if (!this.socket.getSender().isValid()) {
            this.socket.close();
            return true;
        }
        return false;
    }

    private void handleMessageFrame(String stringMsg) {
        JsonObject frame = GsonProvider.parser().parse(stringMsg).getAsJsonObject();
        String innerMsg = frame.get("msg").getAsString();
        String signature = frame.get("signature").getAsString();
        if (innerMsg == null || innerMsg.isEmpty() || signature == null || signature.isEmpty()) {
            throw new IllegalArgumentException("Incomplete message");
        }
        PublicKey remotePublicKey = this.socket.getRemotePublicKey();
        boolean verified = remotePublicKey != null && SignatureAlgorithm.INSTANCE.verify(remotePublicKey, innerMsg, signature);
        JsonObject msg = GsonProvider.parser().parse(innerMsg).getAsJsonObject();
        SocketMessageType type = SocketMessageType.getById(msg.get("type").getAsString());
        if (type == SocketMessageType.HELLO) {
            this.helloHandler.handle(msg);
            return;
        }
        if (!verified) {
            throw new IllegalStateException("Signature not accepted");
        }
        switch (type) {
            case CHANGE_REQUEST: {
                this.changeRequestHandler.handle(msg);
                break;
            }
            case CONNECTED: {
                this.connectedHandler.handle(msg);
                break;
            }
            case PING: {
                this.pingHandler.handle(msg);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid message type: " + String.valueOf((Object)type));
            }
        }
    }

    public CompletableFuture<Void> connectFuture() {
        return this.connectFuture;
    }

    public HandlerHello helloHandler() {
        return this.helloHandler;
    }

    public HandlerConnected connectedHandler() {
        return this.connectedHandler;
    }

    public HandlerPing pingHandler() {
        return this.pingHandler;
    }

    public HandlerChangeRequest changeRequestHandler() {
        return this.changeRequestHandler;
    }
}

