/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.listeners;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.api.implementation.ApiGroup;
import me.lucko.luckperms.common.cache.BufferedRequest;
import me.lucko.luckperms.common.event.LuckPermsEventListener;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.context.ContextUpdateEvent;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.minecraft.class_3222;

public class FabricCommandListUpdater
implements LuckPermsEventListener {
    private final LPFabricPlugin plugin;
    private final LoadingCache<UUID, SendBuffer> sendingBuffers = CaffeineFactory.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(x$0 -> new SendBuffer((UUID)x$0));

    public FabricCommandListUpdater(LPFabricPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void bind(EventBus bus) {
        bus.subscribe(UserDataRecalculateEvent.class, this::onUserDataRecalculate);
        bus.subscribe(GroupDataRecalculateEvent.class, this::onGroupDataRecalculate);
        bus.subscribe(ContextUpdateEvent.class, this::onContextUpdate);
    }

    private void onUserDataRecalculate(UserDataRecalculateEvent e) {
        this.requestUpdate(e.getUser().getUniqueId());
    }

    private void onGroupDataRecalculate(GroupDataRecalculateEvent e) {
        this.plugin.getUserManager().getAll().values().stream().filter(u -> u.resolveInheritanceTree(u.getQueryOptions()).contains(ApiGroup.cast(e.getGroup()))).forEach(u -> this.requestUpdate(u.getUniqueId()));
    }

    private void onContextUpdate(ContextUpdateEvent e) {
        e.getSubject(class_3222.class).ifPresent(p -> this.requestUpdate(p.method_5667()));
    }

    private void requestUpdate(UUID uniqueId) {
        if (!this.plugin.getBootstrap().isPlayerOnline(uniqueId)) {
            return;
        }
        ((SendBuffer)this.sendingBuffers.get((Object)uniqueId)).request();
    }

    private void sendUpdate(UUID uniqueId) {
        this.plugin.getBootstrap().getScheduler().sync().execute(() -> this.plugin.getBootstrap().getPlayer(uniqueId).ifPresent(player -> this.plugin.getBootstrap().getServer().ifPresent(server -> server.method_3760().method_14576(player))));
    }

    private final class SendBuffer
    extends BufferedRequest<Void> {
        private final UUID uniqueId;

        SendBuffer(UUID uniqueId) {
            super(500L, TimeUnit.MILLISECONDS, FabricCommandListUpdater.this.plugin.getBootstrap().getScheduler());
            this.uniqueId = uniqueId;
        }

        @Override
        protected Void perform() {
            FabricCommandListUpdater.this.sendUpdate(this.uniqueId);
            return null;
        }
    }
}

