/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.listeners;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.util.AbstractConnectionListener;
import me.lucko.luckperms.fabric.FabricSenderFactory;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import me.lucko.luckperms.fabric.mixin.ServerLoginNetworkHandlerAccessor;
import me.lucko.luckperms.fabric.model.MixinUser;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public class FabricConnectionListener
extends AbstractConnectionListener {
    private final LPFabricPlugin plugin;

    public FabricConnectionListener(LPFabricPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void registerListeners() {
        ServerLoginConnectionEvents.QUERY_START.register(this::onPreLogin);
        ServerPlayConnectionEvents.JOIN.register(this::onLogin);
        ServerPlayConnectionEvents.DISCONNECT.register(this::onDisconnect);
    }

    private void onPreLogin(class_3248 netHandler, MinecraftServer server, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer sync) {
        GameProfile profile = ((ServerLoginNetworkHandlerAccessor)netHandler).getGameProfile();
        UUID uniqueId = profile.id();
        String username = profile.name();
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing pre-login (sync phase) for " + String.valueOf(uniqueId) + " - " + username);
        }
        sync.waitFor(CompletableFuture.runAsync(() -> this.onPreLoginAsync(netHandler, uniqueId, username), this.plugin.getBootstrap().getScheduler().async()));
    }

    private void onPreLoginAsync(class_3248 netHandler, UUID uniqueId, String username) {
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing pre-login (async phase) for " + String.valueOf(uniqueId) + " - " + username);
        }
        try {
            User user = this.loadUser(uniqueId, username);
            this.recordConnection(uniqueId);
            this.plugin.getEventDispatcher().dispatchPlayerLoginProcess(uniqueId, username, user);
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Exception occurred whilst loading data for " + String.valueOf(uniqueId) + " - " + username, ex);
            Component reason = TranslationManager.render(Message.LOADING_DATABASE_ERROR.build());
            netHandler.method_14380(FabricSenderFactory.toNativeText(reason));
            this.plugin.getEventDispatcher().dispatchPlayerLoginProcess(uniqueId, username, null);
        }
    }

    private void onLogin(class_3244 netHandler, PacketSender packetSender, MinecraftServer server) {
        User user;
        class_3222 player = netHandler.field_14140;
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing login for " + String.valueOf(player.method_5667()) + " - " + player.method_7334().name());
        }
        if ((user = (User)this.plugin.getUserManager().getIfLoaded(player.method_5667())) == null) {
            this.plugin.getLogger().warn("User " + String.valueOf(player.method_5667()) + " - " + String.valueOf(player.method_7334().id()) + " doesn't currently have data pre-loaded - denying login.");
            Component reason = TranslationManager.render(Message.LOADING_STATE_ERROR.build());
            netHandler.method_52396(FabricSenderFactory.toNativeText(reason));
            return;
        }
        ((MixinUser)player).luckperms$initializePermissions(user);
        this.plugin.getContextManager().signalContextUpdate(player);
    }

    private void onDisconnect(class_3244 netHandler, MinecraftServer server) {
        if (!server.method_3750()) {
            this.handleDisconnect(netHandler.field_14140.method_5667());
        }
    }
}

