/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.ECAbilitySources;
import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.ECPlaceholderRegistry;
import com.fibermc.essentialcommands.EssentialCommandRegistry;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.Updater;
import com.fibermc.essentialcommands.commands.RulesCommand;
import com.fibermc.essentialcommands.config.EssentialCommandsConfig;
import com.fibermc.essentialcommands.config.EssentialCommandsConfigSnapshot;
import com.fibermc.essentialcommands.text.ECText;
import dev.jpcode.eccore.util.TimeUtil;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EssentialCommands
implements ModInitializer {
    private static final String MOD_CONTAINER_ID = "essential_commands";
    public static final ModMetadata MOD_METADATA = FabricLoader.getInstance().getModContainer("essential_commands").map(ModContainer::getMetadata).orElse(null);
    public static final String MOD_ID = MOD_METADATA == null ? "essentialcommands | ERR - NO MOD DATA" : MOD_METADATA.getId();
    public static final Logger LOGGER = LogManager.getLogger((String)"EssentialCommands");
    public static final EssentialCommandsConfig BACKING_CONFIG = new EssentialCommandsConfig(Path.of("./config/EssentialCommands.properties", new String[0]), "Essential Commands Config", "https://github.com/John-Paul-R/Essential-Commands/wiki/Config-Documentation");
    public static EssentialCommandsConfigSnapshot CONFIG = EssentialCommandsConfigSnapshot.create(BACKING_CONFIG);
    public static boolean VANISH_PRESENT;

    public static void log(Level level, String message, Object ... args) {
        String logPrefix = "[EssentialCommands]: ";
        LOGGER.log(level, "[EssentialCommands]: ".concat(message), args);
    }

    public static void refreshConfigSnapshot() {
        CONFIG = EssentialCommandsConfigSnapshot.create(BACKING_CONFIG);
    }

    public void onInitialize() {
        if (MOD_METADATA == null) {
            EssentialCommands.log(Level.WARN, "failed to load mod metadata using mod container id '{}' ", MOD_CONTAINER_ID);
        }
        EssentialCommands.log(Level.INFO, "Mod Load Initiated.", new Object[0]);
        BACKING_CONFIG.registerLoadHandler(backingConfig -> {
            CONFIG = EssentialCommandsConfigSnapshot.create(backingConfig);
        });
        BACKING_CONFIG.loadOrCreateProperties();
        ECPlaceholderRegistry.register();
        ECAbilitySources.init();
        ManagerLocator managers = ManagerLocator.getInstance();
        managers.init();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ECText.init(server);
            TimeUtil.init((MinecraftServer)server);
            managers.onServerStart(server);
            ECPerms.init();
            if (EssentialCommands.CONFIG.ENABLE_RULES) {
                try {
                    RulesCommand.reload(server);
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred while loading EssentialCommands rules file.");
                    e.printStackTrace();
                }
            }
        });
        CommandRegistrationCallback.EVENT.register(EssentialCommandRegistry::register);
        if (EssentialCommands.CONFIG.CHECK_FOR_UPDATES) {
            Updater.checkForUpdates();
        }
        VANISH_PRESENT = FabricLoader.getInstance().isModLoaded("melius-vanish");
        EssentialCommands.log(Level.INFO, "Mod Load Complete.", new Object[0]);
    }
}

