/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.codec.Codecs;
import com.fibermc.essentialcommands.datafixer.WorldDataDataFixer;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.WarpStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldData {
    @Nullable
    private MinecraftLocation spawnLocation;
    @NotNull
    private final WarpStorage warps;
    private static final String SCHEMA_VERSION_KEY = "_sv";
    private static final int SCHEMA_VERSION = 1;
    public static final Codec<WorldData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.MINECRAFT_LOCATION.optionalFieldOf("spawn").forGetter(WorldData::getSpawn), (App)Codecs.WARP_STORAGE.fieldOf("warps").forGetter(WorldData::warps)).apply((Applicative)instance, WorldData::new));

    WorldData() {
        this.spawnLocation = null;
        this.warps = new WarpStorage();
    }

    WorldData(Optional<MinecraftLocation> spawnLocation, @NotNull WarpStorage warps) {
        this.spawnLocation = spawnLocation.orElse(null);
        this.warps = warps;
    }

    public WarpStorage warps() {
        return this.warps;
    }

    public Optional<MinecraftLocation> getSpawn() {
        return Optional.ofNullable(this.spawnLocation);
    }

    public void setSpawn(@Nullable MinecraftLocation spawn) {
        this.spawnLocation = spawn;
    }

    public static WorldData fromNbt(class_2487 nbt) {
        nbt = nbt.method_10562("data").orElse(nbt);
        nbt = (class_2487)((class_2520)WorldDataDataFixer.createDataFixer().build().fixer().update(WorldDataDataFixer.TYPE, new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt), nbt.method_68083(SCHEMA_VERSION_KEY, 0), 1).getValue()).method_68571().orElseThrow();
        return (WorldData)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow();
    }

    public class_2487 toNbt() {
        class_2487 data = (class_2487)((class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow()).method_68571().orElseThrow();
        data.method_10569(SCHEMA_VERSION_KEY, 1);
        return data;
    }
}

