/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.WorldData;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.WarpLocation;
import com.fibermc.essentialcommands.types.WarpStorage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class WorldDataManager
extends class_18 {
    private Path saveDir;
    private File worldDataFile;
    private WorldData data;
    public final Event<Consumer<WarpStorage>> warpsLoadEvent = EventFactory.createArrayBacked(Consumer.class, listeners -> warps -> {
        for (Consumer event : listeners) {
            event.accept(warps);
        }
    });

    public WorldDataManager() {
        this.data = new WorldData();
    }

    public static WorldDataManager createForServer(MinecraftServer server) {
        WorldDataManager worldDataManager = new WorldDataManager();
        worldDataManager.onServerStart(server);
        return worldDataManager;
    }

    public void onServerStart(MinecraftServer server) {
        this.saveDir = server.method_27050(class_5218.field_24188).resolve("essentialcommands");
        try {
            Files.createDirectories(this.saveDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.worldDataFile = this.saveDir.resolve("world_data.dat").toFile();
        try {
            boolean fileExisted;
            boolean bl = fileExisted = !this.worldDataFile.createNewFile();
            if (fileExisted && this.worldDataFile.length() > 0L) {
                class_2487 tag = class_2507.method_30613((Path)this.worldDataFile.toPath(), (class_2505)class_2505.method_53898());
                this.data = WorldData.fromNbt(tag.method_10562("data").orElse(tag));
                ((Consumer)this.warpsLoadEvent.invoker()).accept(this.data.warps());
            } else {
                this.method_80();
                this.save();
            }
        }
        catch (IOException e) {
            EssentialCommands.log(Level.ERROR, String.format("An unexpected error occoured while loading the Essential Commands World Data file (Path: '%s')", this.worldDataFile.getPath()), new Object[0]);
            e.printStackTrace();
        }
    }

    private File getDataFile() {
        return this.worldDataFile;
    }

    public void save() {
        EssentialCommands.log(Level.INFO, "Saving world_data.dat (Spawn/Warps)...", new Object[0]);
        class_2487 data = this.data.toNbt();
        try {
            class_2507.method_30614((class_2487)data, (Path)this.worldDataFile.toPath());
        }
        catch (IOException e) {
            EssentialCommands.LOGGER.error("Could not save data {}", (Object)this, (Object)e);
        }
        EssentialCommands.log(Level.INFO, "world_data.dat saved.", new Object[0]);
    }

    public void setWarp(String warpName, MinecraftLocation location, boolean requiresPermission) throws CommandSyntaxException {
        this.data.warps().putCommand(warpName, new WarpLocation(location, requiresPermission ? warpName : null, warpName));
        this.method_80();
        this.save();
    }

    public boolean delWarp(String warpName) {
        MinecraftLocation prevValue = (MinecraftLocation)this.data.warps().remove(warpName);
        this.method_80();
        this.save();
        return prevValue != null;
    }

    public WarpLocation getWarp(String warpName) {
        return (WarpLocation)this.data.warps().get(warpName);
    }

    public List<String> getWarpNames() {
        return this.data.warps().keySet().stream().toList();
    }

    public Stream<WarpLocation> getAccessibleWarps(class_3222 player) {
        Stream<WarpLocation> warpsStream = this.data.warps().values().stream();
        return EssentialCommands.CONFIG.USE_PERMISSIONS_API ? warpsStream.filter(loc -> loc.hasPermission(player)) : warpsStream;
    }

    public Set<Map.Entry<String, WarpLocation>> getWarpEntries() {
        return this.data.warps().entrySet();
    }

    public void setSpawn(MinecraftLocation location) {
        this.data.setSpawn(location);
        this.method_80();
        this.save();
    }

    public Optional<MinecraftLocation> getSpawn() {
        return this.data.getSpawn();
    }
}

