/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class FlySpeedCommand
implements Command<class_2168> {
    static int speedMultiplier = 20;

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 targetPlayer = CommandUtil.getCommandTargetPlayer(context);
        int newSpeed = IntegerArgumentType.getInteger(context, (String)"fly_speed");
        FlySpeedCommand.exec(source, targetPlayer, newSpeed);
        return 1;
    }

    public int reset(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 targetPlayer = CommandUtil.getCommandTargetPlayer(context);
        FlySpeedCommand.exec(source, targetPlayer, 1);
        return 1;
    }

    public static void exec(class_2168 source, class_3222 target, int flySpeed) throws CommandSyntaxException {
        ECText ecTextTarget = ECText.access(target);
        if (flySpeed > EssentialCommands.CONFIG.FLY_MAX_SPEED) {
            throw CommandUtil.createSimpleException((Message)ecTextTarget.getText("cmd.fly.speed.error.limit", TextFormatType.Error, new class_2561[]{ecTextTarget.accent(String.valueOf(EssentialCommands.CONFIG.FLY_MAX_SPEED))}));
        }
        int oldFlySpeed = (int)(target.method_31549().method_7252() * (float)speedMultiplier);
        target.method_31549().method_7248((float)flySpeed / (float)speedMultiplier);
        target.method_7355();
        if (!Objects.equals(source.method_44023(), target)) {
            ECText ecTextSource = ECText.access(source.method_44023());
            source.method_9226(() -> ecTextSource.getText("cmd.fly.speed.feedback.update.other", new class_2561[]{ecTextSource.accent(String.valueOf(oldFlySpeed)), ecTextSource.accent(String.valueOf(flySpeed)), target.method_5476()}), EssentialCommands.CONFIG.BROADCAST_TO_OPS);
        }
        target.method_64398((class_2561)ecTextTarget.getText("cmd.fly.speed.feedback.update", new class_2561[]{ecTextTarget.accent(String.valueOf(oldFlySpeed)), ecTextTarget.accent(String.valueOf(flySpeed))}));
    }
}

