/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.commands.suggestions.ListSuggestion;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.teleportation.PlayerTeleporter;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class HomeCommand
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        return HomeCommand.exec(senderPlayerData, homeName);
    }

    private static PlayerData getTargetPlayerData(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
    }

    public static String getSoleHomeName(PlayerData playerData) throws CommandSyntaxException {
        Set<String> homeNames = playerData.getHomeNames();
        ECText ecText = ECText.access(playerData.getPlayer());
        if (homeNames.size() > 1) {
            throw CommandUtil.createSimpleException((Message)ecText.getText("cmd.home.tp.error.shortcut_more_than_one", TextFormatType.Error, new class_2561[0]));
        }
        if (homeNames.isEmpty()) {
            throw CommandUtil.createSimpleException((Message)ecText.getText("cmd.home.tp.error.shortcut_none_exist", TextFormatType.Error, new class_2561[0]));
        }
        return (String)homeNames.stream().findAny().get();
    }

    public int runDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData playerData = ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
        return HomeCommand.exec(playerData, HomeCommand.getSoleHomeName(playerData));
    }

    private static int exec(PlayerData senderPlayerData, String homeName) throws CommandSyntaxException {
        return HomeCommand.exec(senderPlayerData, senderPlayerData, homeName);
    }

    public static int exec(PlayerData senderPlayerData, PlayerData targetPlayerData, String homeName) throws CommandSyntaxException {
        NamedMinecraftLocation loc = targetPlayerData.getHomeLocation(homeName);
        ECText ecText = ECText.access(senderPlayerData.getPlayer());
        if (loc == null) {
            class_5250 msg = ecText.getText("cmd.home.tp.error.not_found", TextFormatType.Error, new class_2561[]{class_2561.method_43470((String)homeName)});
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)msg), (Message)msg);
        }
        class_5250 homeNameText = ecText.getText("cmd.home.location_name", TextFormatType.Default, new class_2561[]{ecText.accent(homeName)});
        PlayerTeleporter.requestTeleport(senderPlayerData, (MinecraftLocation)loc, homeNameText);
        return 1;
    }

    public static class Suggestion {
        public static final SuggestionProvider<class_2168> LIST_SUGGESTION_PROVIDER = ListSuggestion.ofContext(Suggestion::getSuggestionsList);

        public static List<String> getSuggestionsList(CommandContext<class_2168> context) throws CommandSyntaxException {
            return new ArrayList<String>(HomeCommand.getTargetPlayerData(context).getHomeNames());
        }

        public static Set<Map.Entry<String, NamedMinecraftLocation>> getSuggestionEntries(CommandContext<class_2168> context) throws CommandSyntaxException {
            return HomeCommand.getTargetPlayerData(context).getHomeEntries();
        }
    }
}

