/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.ManagerLocator;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.commands.HomeCommand;
import com.fibermc.essentialcommands.commands.ListCommandFactory;
import com.fibermc.essentialcommands.commands.suggestions.ListSuggestion;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

public class HomeTeleportOtherCommand
extends HomeCommand
implements Command<class_2168> {
    @Override
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        return HomeCommand.exec(senderPlayerData, HomeTeleportOtherCommand.getTargetPlayerData(context), homeName);
    }

    private static PlayerData getTargetPlayerData(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ((ServerPlayerEntityAccess)class_2186.method_9315(context, (String)"target_player")).ec$getPlayerData();
    }

    @Override
    public int runDefault(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
        PlayerData targetPlayerData = HomeTeleportOtherCommand.getTargetPlayerData(context);
        return HomeCommand.exec(senderPlayerData, targetPlayerData, HomeCommand.getSoleHomeName(targetPlayerData));
    }

    public int runOfflinePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = ((ServerPlayerEntityAccess)((class_2168)context.getSource()).method_9207()).ec$getPlayerData();
        String homeName = StringArgumentType.getString(context, (String)"home_name");
        String targetPlayerName = StringArgumentType.getString(context, (String)"target_player");
        ManagerLocator.getInstance().getOfflinePlayerRepo().getOfflinePlayerByNameAsync(targetPlayerName).whenComplete((playerEntity, err) -> {
            if (playerEntity == null) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"No player with the specified name found."));
                return;
            }
            PlayerData targetPlayerData = ((ServerPlayerEntityAccess)playerEntity).ec$getPlayerData();
            try {
                HomeCommand.exec(senderPlayerData, targetPlayerData, homeName);
            }
            catch (CommandSyntaxException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)ECText.access(senderPlayerData.getPlayer()).error(e.getMessage()));
            }
        });
        return 1;
    }

    public static int runListOffline(CommandContext<class_2168> context) throws CommandSyntaxException {
        String targetPlayerName = StringArgumentType.getString(context, (String)"target_player");
        PlayerProfile senderPlayerProfile = PlayerProfile.accessFromContextOrThrow(context);
        ManagerLocator.getInstance().getOfflinePlayerRepo().getOfflinePlayerByNameAsync(targetPlayerName).whenComplete((targetPlayerEntity, err) -> {
            if (targetPlayerEntity == null) {
                ((class_2168)context.getSource()).method_9213(class_2561.method_30163((String)"No player with the specified name found."));
                return;
            }
            PlayerData targetPlayerData = ((ServerPlayerEntityAccess)targetPlayerEntity).ec$getPlayerData();
            class_2561 suggestionText = ListCommandFactory.getSuggestionText(ECText.getInstance().getString("cmd.home.list.start"), "home tp_offline %s".formatted(targetPlayerName), targetPlayerData.getHomeEntries(), Map.Entry::getKey, senderPlayerProfile);
            ((class_2168)context.getSource()).method_9226(() -> suggestionText, EssentialCommands.CONFIG.BROADCAST_TO_OPS);
        });
        return 0;
    }

    public static class Suggestion {
        public static final SuggestionProvider<class_2168> LIST_SUGGESTION_PROVIDER = ListSuggestion.ofContext(Suggestion::getSuggestionsList);

        public static List<String> getSuggestionsList(CommandContext<class_2168> context) throws CommandSyntaxException {
            return new ArrayList<String>(HomeTeleportOtherCommand.getTargetPlayerData(context).getHomeNames());
        }

        public static Set<Map.Entry<String, NamedMinecraftLocation>> getSuggestionEntries(CommandContext<class_2168> context) throws CommandSyntaxException {
            return HomeTeleportOtherCommand.getTargetPlayerData(context).getHomeEntries();
        }
    }
}

