/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.datafixer;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Supplier;

public final class PlayerDataDataFixer {
    public static final DSL.TypeReference TYPE = () -> "player_data";

    private PlayerDataDataFixer() {
    }

    public static DataFixerBuilder createDataFixer() {
        DataFixerBuilder builder = new DataFixerBuilder(1);
        builder.addSchema(0, V0::new);
        Schema v1Schema = builder.addSchema(1, V1::new);
        builder.addFixer((DataFix)new RemoveEmptyObjectSpawnFix(v1Schema));
        return builder;
    }

    public static class RemoveEmptyObjectSpawnFix
    extends DataFix {
        public RemoveEmptyObjectSpawnFix(Schema outputSchema) {
            super(outputSchema, false);
        }

        public TypeRewriteRule makeRule() {
            Type inputType = this.getInputSchema().getType(TYPE);
            return this.fixTypeEverywhereTyped("NoEmptyHomesObject", inputType, typed -> typed.update(DSL.remainderFinder(), this::removeEmptyHomesField));
        }

        private Dynamic<?> removeEmptyHomesField(Dynamic<?> dynamic) {
            Boolean hasSpawnValueWithEmptyObject = (Boolean)dynamic.get("homes").get().mapOrElse(spawn -> (Boolean)spawn.getMapValues().map(Map::isEmpty).getOrThrow(), _keyMissingError -> false);
            if (hasSpawnValueWithEmptyObject.booleanValue()) {
                return dynamic.remove("homes");
            }
            return dynamic;
        }
    }

    public static class V1
    extends Schema {
        public V1(int versionKey, Schema parent) {
            super(versionKey, parent);
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
            schema.registerType(true, TYPE, this::v1);
        }

        public Map<String, Supplier<TypeTemplate>> registerEntities(Schema schema) {
            return Maps.newHashMap();
        }

        public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
            return Maps.newHashMap();
        }

        private TypeTemplate v1() {
            return DSL.remainder();
        }
    }

    public static class V0
    extends Schema {
        public V0(int versionKey, Schema parent) {
            super(versionKey, parent);
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
            this.registerType(true, TYPE, this::v0);
        }

        public Map<String, Supplier<TypeTemplate>> registerEntities(Schema schema) {
            return Maps.newHashMap();
        }

        public Map<String, Supplier<TypeTemplate>> registerBlockEntities(Schema schema) {
            return Maps.newHashMap();
        }

        private TypeTemplate v0() {
            return DSL.remainder();
        }
    }
}

