/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.types.NamedLocationStorage;
import com.fibermc.essentialcommands.util.FileUtil;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public final class PlayerDataFactory {
    private PlayerDataFactory() {
    }

    private static PlayerData create(class_3222 player, File playerDataFile) {
        boolean fileExisted = false;
        try {
            fileExisted = !playerDataFile.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (fileExisted && playerDataFile.length() != 0L) {
            try {
                class_2487 tag = class_2507.method_30613((Path)playerDataFile.toPath(), (class_2505)class_2505.method_53898());
                tag = PlayerData.fixData(tag);
                PlayerData playerData = (PlayerData)PlayerData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow();
                playerData.initializeRuntimeState(player, playerDataFile);
                return playerData;
            }
            catch (IOException e) {
                EssentialCommands.log(Level.WARN, "Failed to load essential_commands player data for {%s}", player.method_5477().getString());
                e.printStackTrace();
                return new PlayerData(player, playerDataFile);
            }
        }
        PlayerData pData = new PlayerData(player, playerDataFile);
        pData.method_80();
        pData.save();
        return pData;
    }

    public static PlayerData create(NamedLocationStorage homes, File saveFile) {
        String fileName = saveFile.getName();
        UUID playerUuid = UUID.fromString(fileName.substring(0, fileName.indexOf(".dat")));
        PlayerData playerData = null;
        if (Files.exists(saveFile.toPath(), new LinkOption[0]) && saveFile.length() != 0L) {
            try {
                class_2487 tag = class_2507.method_30613((Path)saveFile.toPath(), (class_2505)class_2505.method_53898());
                class_2487 dataTag = tag.method_10562("data").orElse(tag);
                playerData = (PlayerData)PlayerData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)dataTag).getOrThrow();
                playerData.initializeSaveFileField(saveFile);
                playerData.homes.putAll(homes);
            }
            catch (IOException e) {
                EssentialCommands.log(Level.WARN, "Failed to load essential_commands player data for {" + String.valueOf(playerUuid) + "}", new Object[0]);
                e.printStackTrace();
            }
        } else {
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (playerData == null) {
            playerData = new PlayerData(saveFile);
        }
        playerData.method_80();
        return playerData;
    }

    public static PlayerData create(class_3222 player) {
        try {
            return PlayerDataFactory.create(player, PlayerDataFactory.getPlayerDataFile(player));
        }
        catch (IOException ex) {
            EssentialCommands.log(Level.ERROR, "Failed to create player data file for player with id '{}'. Player data may fail to save, or other unexpected behavior may occur.", player.method_5845());
            EssentialCommands.LOGGER.error((Object)ex);
            return new PlayerData(player, null);
        }
    }

    public static Path getPlayerDataDirectoryPath(MinecraftServer server) throws IOException {
        return FileUtil.getOrCreateWorldDirectory(server, "modplayerdata");
    }

    private static File getPlayerDataFile(class_3222 player) throws IOException {
        return PlayerDataFactory.getPlayerDataDirectoryPath(player.method_51469().method_8503()).resolve(player.method_5845() + ".dat").toFile();
    }
}

