/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.teleportation;

import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.teleportation.TeleportRequest;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;

public class OutgoingTeleportRequests {
    private final ArrayList<TeleportRequest> requests = new ArrayList();

    public void add(TeleportRequest request) {
        if (request.type == TeleportRequest.Type.TPA_TO) {
            this.requests.clear();
        }
        this.requests.add(request);
    }

    public Stream<TeleportRequest> stream() {
        return this.requests.stream();
    }

    public void remove(TeleportRequest request) {
        this.requests.remove(request);
    }

    public Optional<TeleportRequest> getRequestToPlayer(PlayerData targetPlayer) {
        return this.stream().filter(r -> r.getTargetPlayerData() == targetPlayer).findAny();
    }

    public void clear() {
        this.requests.forEach(TeleportRequest::end);
        this.requests.clear();
    }

    public int size() {
        return this.requests.size();
    }
}

