/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.teleportation;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.teleportation.QueuedLocationTeleport;
import com.fibermc.essentialcommands.teleportation.QueuedTeleport;
import com.fibermc.essentialcommands.teleportation.TeleportManager;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import dev.jpcode.eccore.util.TextUtil;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PlayerTeleporter {
    private static final Logger LOGGER = LogManager.getLogger((String)"PlayerTeleporter");
    private static class_8942 errorReporter = new class_8942.class_8943();

    private PlayerTeleporter() {
    }

    public static void requestTeleport(PlayerData pData, MinecraftLocation dest, class_5250 destName) {
        PlayerTeleporter.requestTeleport(new QueuedLocationTeleport(pData, dest, destName));
    }

    public static void requestTeleport(QueuedTeleport queuedTeleport) {
        class_3222 player = queuedTeleport.getPlayerData().getPlayer();
        if (PlayerTeleporter.playerHasTpRulesBypass(player, "essentialcommands.bypass.teleport_delay") || EssentialCommands.CONFIG.TELEPORT_DELAY_TICKS <= 0) {
            PlayerTeleporter.teleport(queuedTeleport.getPlayerData(), queuedTeleport.getDest(), queuedTeleport.getDestName());
        } else {
            TeleportManager.getInstance().queueTeleport(queuedTeleport);
        }
    }

    public static void requestTeleport(class_3222 playerEntity, MinecraftLocation dest, class_5250 destName) {
        PlayerTeleporter.requestTeleport(((ServerPlayerEntityAccess)playerEntity).ec$getPlayerData(), dest, destName);
    }

    public static void teleport(QueuedTeleport queuedTeleport) {
        queuedTeleport.complete();
        PlayerTeleporter.teleport(queuedTeleport.getPlayerData(), queuedTeleport.getDest(), queuedTeleport.getDestName());
    }

    public static void teleport(PlayerData pData, MinecraftLocation dest, class_5250 destName) {
        class_3222 player = pData.getPlayer();
        if (!EssentialCommands.CONFIG.ALLOW_TELEPORT_BETWEEN_DIMENSIONS && !PlayerTeleporter.playerHasTpRulesBypass(player, "essentialcommands.bypass.allow_teleport_between_dimensions") && dest.dim() != player.method_51469().method_27983()) {
            pData.sendError("teleport.error.interdimensional_teleport_disabled", new class_2561[0]);
            return;
        }
        PlayerTeleporter.execTeleport(player, dest, destName);
    }

    private static void execTeleport(class_3222 playerEntity, MinecraftLocation dest, class_5250 destName) {
        MinecraftServer playerServer = playerEntity.method_51469().method_8503();
        class_3218 targetWorld = playerServer.method_3847(dest.dim());
        if (targetWorld == null) {
            throw new NullPointerException(String.format("Could not find teleport target world, '%s'", dest.dim()));
        }
        class_2338 playerPos = playerEntity.method_24515();
        class_243 targetVec = new class_243(dest.pos().field_1352, dest.pos().field_1351, dest.pos().field_1350);
        playerEntity.method_48105(targetWorld, targetVec.field_1352, targetVec.field_1351, targetVec.field_1350, Set.of(), dest.headYaw(), dest.pitch(), false);
        if (EssentialCommands.CONFIG.TELEPORT_FOLLOWERS) {
            List<class_1321> pets = PlayerTeleporter.detectTamedPets(playerEntity, playerPos);
            PlayerTeleporter.teleportTamedEntities(pets, targetWorld, targetVec, playerEntity);
        }
        PlayerTeleporter.sendTeleportMessage(playerEntity, destName, dest);
    }

    private static List<class_1321> detectTamedPets(class_3222 playerEntity, class_2338 playerPos) {
        double radius = Math.max(EssentialCommands.CONFIG.TELEPORT_FOLLOWERS_RADIUS, 0.0);
        class_3218 playerWorld = playerEntity.method_51469();
        return playerWorld.method_8390(class_1321.class, new class_238(playerPos).method_1014(radius), pet -> {
            boolean isTamed = pet.method_6181();
            class_1309 petOwner = pet.method_35057();
            if (petOwner == null) {
                LOGGER.warn("failed to find owner for pet with id '{}', name '{}'", (Object)pet.method_5667(), (Object)pet.method_5476().getString());
                return false;
            }
            UUID ownerUuid = petOwner.method_5667();
            boolean isSameOwner = ownerUuid != null && ownerUuid.equals(playerEntity.method_5667());
            boolean isSitting = pet.method_24345();
            return isTamed && isSameOwner && !isSitting;
        });
    }

    private static void teleportTamedEntities(List<class_1321> pets, class_3218 targetWorld, class_243 targetVec, class_3222 playerEntity) {
        for (class_1321 pet : pets) {
            if (pet.method_73183() != targetWorld) {
                if (PlayerTeleporter.transferEntityToWorld(pet, targetWorld, targetVec, playerEntity)) continue;
                LOGGER.warn("Failed to transfer pet {} ({}) to {}", (Object)pet.method_5864().method_5882(), (Object)pet.method_5667(), (Object)targetWorld.method_27983().method_29177());
                continue;
            }
            targetWorld.method_8497((int)targetVec.field_1352 >> 4, (int)targetVec.field_1350 >> 4);
            pet.method_6082(targetVec.field_1352, targetVec.field_1351 + 0.5, targetVec.field_1350, false);
        }
    }

    private static boolean transferEntityToWorld(class_1321 pet, class_3218 targetWorld, class_243 targetVec, class_3222 playerEntity) {
        class_11362 entityData = class_11362.method_71458((class_8942)errorReporter);
        pet.method_5786((class_11372)entityData);
        class_11368 entityDataReadView = class_11352.method_71417((class_8942)errorReporter, (class_7225.class_7874)targetWorld.method_30349(), (class_2487)entityData.method_71475());
        class_1297 newPet = class_1299.method_17842((class_11368)entityDataReadView, (class_1937)targetWorld, (class_3730)class_3730.field_16462, e -> {
            e.method_23327(targetVec.field_1352, targetVec.field_1351, targetVec.field_1350);
            return e;
        });
        if (newPet instanceof class_1321) {
            class_1321 newTamedPet = (class_1321)newPet;
            newTamedPet.method_6173(true, true);
            newTamedPet.method_6174((class_1309)playerEntity);
            targetWorld.method_8649((class_1297)newTamedPet);
            if (newTamedPet.method_31481()) {
                LOGGER.error("Failed to spawn pet {} ({}) in {}", (Object)newTamedPet.method_5864().method_5882(), (Object)newTamedPet.method_5667(), (Object)targetWorld.method_27983().method_29177());
                return false;
            }
            pet.method_31472();
            return true;
        }
        LOGGER.error("Failed to create entity from NBT for pet ({})!", (Object)pet.method_5667());
        return false;
    }

    private static void sendTeleportMessage(class_3222 playerEntity, class_5250 destName, MinecraftLocation dest) {
        ServerPlayerEntityAccess playerAccess = (ServerPlayerEntityAccess)playerEntity;
        PlayerProfile playerProfile = playerAccess.ec$getProfile();
        playerAccess.ec$getPlayerData().sendMessage("teleport.done", new class_2561[]{playerProfile.shouldPrintTeleportCoordinates().orElse(EssentialCommands.CONFIG.PRINT_TELEPORT_COORDINATES) != false ? TextUtil.join((class_2561[])new class_2561[]{destName, dest.toText(playerProfile)}, (class_2561)class_2561.method_43470((String)" ")) : destName});
    }

    static boolean playerHasTpRulesBypass(class_3222 player, String permission) {
        return player.method_64475(4) && EssentialCommands.CONFIG.OPS_BYPASS_TELEPORT_RULES || ECPerms.check(player.method_64396(), permission, 5);
    }
}

