/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.types;

import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.codec.Codecs;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class WarpLocation
extends NamedMinecraftLocation {
    public static final Codec<WarpLocation> CODEC = Codecs.WARP_LOCATION;
    private String permissionString;

    private WarpLocation() {
    }

    public WarpLocation(NamedMinecraftLocation location, String permissionString) {
        super(location, location.getName());
        this.permissionString = permissionString;
    }

    public WarpLocation(MinecraftLocation location, String permissionString, String name) {
        super(location, name);
        this.permissionString = permissionString;
    }

    public WarpLocation(class_5321<class_1937> dim, double x, double y, double z, float headYaw, float pitch, Optional<String> name, Optional<String> permissionString) {
        super(dim, x, y, z, headYaw, pitch, name);
        this.permissionString = permissionString.orElse(null);
    }

    public static WarpLocation fromNbt(class_2487 tag) {
        DataResult result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag);
        if (result.isSuccess()) {
            return (WarpLocation)result.getOrThrow();
        }
        throw new RuntimeException("Failed to parse WarpLocation from NBT: " + String.valueOf(result.error()));
    }

    public static WarpLocation setName(WarpLocation value, String key) {
        value.name = key;
        return value;
    }

    @Override
    public class_2487 asNbt() {
        return this.writeNbt(new class_2487());
    }

    @Override
    public class_2487 writeNbt(class_2487 tag) {
        return (class_2487)((class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow()).method_68571().orElseThrow();
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public boolean hasPermission(class_3222 player) {
        return this.permissionString == null || ECPerms.check(player.method_64396(), String.format("%s.%s", "essentialcommands.warp.tp_named", this.permissionString));
    }
}

