# https://nix-community.github.io/plasma-manager/options.xhtml

{ pkgs, lib, ... }:
let
  toggles = import ./../toggles.nix;
in
{
  imports = [ ] ++ lib.optional (toggles.neverSleep.enable or false) ./../homeModules/serverfyLaptop.nix;



  programs.plasma = {
    enable = true;

    input.touchpads = [{
      enable = true;
      name = "1A582011:00 06CB:CD73 Touchpad";
      vendorId = "06CB";
      productId = "CD73";
      naturalScroll = true;
    }];

    kscreenlocker = {
      #         lockOnStartup = false;
      # lockOnResume = false;
      passwordRequired = true;
    };
  };
}
