{ pkgs, ... }: {
  programs.ydotool.enable = true;
  users.users = {
    iouhase = {
      extraGroups = [ "uinput" "ydotool" ];
    };
  };
  security.sudo.extraRules = [
    {
      users = [ "iouhase" ];
      commands = [
        {
          command = "/run/current-system/sw/bin/ydotool";
          options = [ "NOPASSWD" ];
        }
      ];
    }
  ];
  environment.variables.YDOTOOL_SOCKET = "/run/ydotoold/socket";
}
