# Server nixos configuration

This is the configuration running on my homebrew server.
It is perfect in and no other config is in any way shape or form better.


# Features

- Forgejo git instance
- Vaultwarden password manager
- Jellyfin media server
 - Sonnar, Radarr, Jackett and transmission auto-torrenting setup in declarative [astro/microvm](https://github.com/astro/microvm.nix) virtual machine behind a VPN.
- ZFS RaidZ (Raid5) for data resilience with automated emails for failed drives
- Self-hosted mail server for sending emails
- Simple file structure for easy extension
- Freshrss feed with rss-bridge


# How to Install

## Prepare device

Install the [nixos boot ISO](https://nixos.org/download/) and run it on your device.
Once booted run

```sh
$ sudo passwd
$ ip a
```

to set a password for the `nix` user and display your ip.
Once done you can ssh into the device and generate a nix hardware config with

```sh
$ ssh nix@<ip>
$ sudo mkdir /mnt
$ sudo nixos-generate-config --root /mnt --no-filesystem
```

This will generate the file `/mnt/hardware-config.nix` that you can then copy to your 
computer.

## Install configuration

### Prepare repo

1. Clone the repo
  - `git clone https://git.spoodythe.one/spoody/server-configuration`
1. Copy the `hardware-configuration.nix` from your device to the repo folder.
  - `scp nix@<ip>:/mnt/hardware-configuration.nix /path/to/repo/hardware-configuration.nix`
1. Add/change the device configuration in `flake.nix`
  - This includes configuring which (if any) disks should be included in the raid array, as well as which disk is the main root disk.

### Install remotely

Run the command

```sh
nix run github:nix-community/nixos-anywhere -- --flake '.#<your configuration>' --target-host nixos@<ip>
```

This will automatically install the configuration to your server.

## Copy configuration to server

Once the configuration has been installed push your modified repo to a git service and pull it on the server.

# People i ~~stole from~~ got inspired by

- [poz](https://poz.pet/)
- myself
