# Main configuration entrypoint file
{
  pkgs,
  inputs,
  ...
}: {
  imports = [
    ./services/nginx.nix
    ./services/jellyfin.nix
    ./services/auto-torrent.nix
    ./services/misc.nix

    ./modules/git.nix
    ./modules/nix-settings.nix
    ./modules/microvm.nix

    (import ./modules/networking-shared.nix {hostname = "jellyfin";})
    (import ./modules/users.nix {main-user = "user";})
  ];

  boot.loader = {
    systemd-boot.enable = true;
    efi.canTouchEfiVariables = true;
    timeout = 0;
  };
  boot.kernelModules = [
    "coretemp"
    "nct6775"
  ];
  boot.kernelPackages = pkgs.linuxKernel.packages.linux_hardened;

  # Enable microcode updates
  hardware.enableRedistributableFirmware = true;

  environment.systemPackages = with pkgs; [
    wget
    curl
    git
    vim
  ];

  programs.nano.enable = false;
  environment.variables = {
    EDITOR = "vim"; # FUCK NANO
  };

  time.timeZone = "Europe/Copenhagen";

  security.sudo = {
    enable = true;
    # I know what im doing
    extraConfig = ''
      Defaults  lecture = never
    '';
  };

  # Without this rebuilds on hardened kernel doesnt work
  security.unprivilegedUsernsClone = true;

  system.stateVersion = "24.11";
}
