{
  pkgs,
  lib,
  root-disk ? throw "Expected a mf disk brother",
  swap-size ? -1,
  ...
}: let
  gb = x: 1024 * 1024 * 1024 * x;
in {
  disko.devices = {
    disk = {
      # Main SSD where /nix/store /etc /boot etc. is located.
      main = {
        type = "disk";
        device = root-disk;
        content = {
          type = "gpt";
          partitions = {
            # Define a 512 megabyte boot partition
            boot = {
              size = "512M";
              type = "EF00";
              content = {
                type = "filesystem";
                format = "vfat";
                mountpoint = "/boot";
                mountOptions = ["umask=0077"];
              };
            };
            # If the swap argument is defined then create a swap partition of the given size
            swap = lib.mkIf (swap-size != -1) {
              size = swap-size;
              content = {
                type = "swap";
                discardPolicy = "both";
                resumeDevice = true;
              };
            };
            # Finally allocate the rest of the disk as a zfs device
            root = {
              size = "100%";
              content = {
                type = "filesystem";
                format = "ext4";
                mountpoint = "/";
              };
            };
          };
        };
      };
    };
  };
}
