{
  description = "Configuration for NAS Server";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-unstable";

    disko = {
      url = "github:nix-community/disko";
      inputs.nixpkgs.follows = "nixpkgs";
    };

    agenix = {
      url = "github:ryantm/agenix";
      inputs.nixpkgs.follows = "nixpkgs";
    };

    microvm = {
      url = "github:astro/microvm.nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = {
    self,
    nixpkgs,
    ...
  } @ inputs: let
    system = "x86_64-linux";
    pkgs = import nixpkgs {inherit system;};
  in {
    formatter.${system} = pkgs.alejandra;

    nixosConfigurations = let
      modules = [
        inputs.disko.nixosModules.default
        inputs.agenix.nixosModules.default
        inputs.microvm.nixosModules.host
      ];
    in {
      server-vm = nixpkgs.lib.nixosSystem {
        specialArgs = {inherit inputs;};
        modules =
          [
            (import ./disko.nix {
              inherit pkgs;
              lib = pkgs.lib;
              swap-size = "16G";
              root-disk = "/dev/vda";
              raid-disks = [
                "vdb"
                "vdc"
                "vdd"
              ];
            })

            ./vm-hardware-configuration.nix
            ./configuration.nix
          ]
          ++ modules;
      };

      server = nixpkgs.lib.nixosSystem {
        specialArgs = {inherit inputs;};
        modules =
          [
            (import ./disko.nix {
              inherit pkgs;
              lib = pkgs.lib;
              root-disk = "/dev/sda";
            })

            ./modules/networking-metal.nix
            ./hardware-configuration.nix
            ./configuration.nix
          ]
          ++ modules;
      };
    };
  };
}
