{
  pkgs,
  config,
  ...
}: let
  attrSet = pkgs.lib.lists.imap1 (i: v: {
    name = v;
    index = i;
  }) (builtins.attrNames config.microvm.vms);
in {
  systemd.network.networks = builtins.listToAttrs (builtins.map ({
      name,
      index,
    }: {
      name = "30-vm${toString index}";
      value = {
        matchConfig.Name = "vm${toString index}";
        address = [
          "10.0.${toString index}.254/24" # Host gateway
        ];
        routes = [
          {
            Destination = "10.0.${toString index}.1/24";
          }
        ];
        networkConfig = {
          IPv4Forwarding = true;
        };
      };
    })
    attrSet);

  # NAT (make vms accessible in host)
  networking.nat = {
    enable = true;
    externalInterface = "enp2s0";
    internalIPs = ["10.0.1.0/24"];
    internalInterfaces = builtins.genList (x: "vm${toString x}") (builtins.length attrSet);
  };
}
