{pkgs, ...}: {
  programs.nvf = {
    enable = true;
    settings = {
      vim.vimAlias = true;

      # Autocomplete
      vim.autocomplete.blink-cmp = {
        enable = true;
        setupOpts = {
        };
      };

      # LSP
      vim.lsp = {
        enable = true;
        inlayHints.enable = false;
        lspconfig.enable = true;

        mappings = {
          codeAction = "<leader>a";
          format = "<F3>";
          goToDefinition = "gd";
          goToDeclaration = "gD";
          listDocumentSymbols = "<leader>s";
          openDiagnosticFloat = "gl";
          renameSymbol = "<leader>r";
        };

        servers = {
          "*" = {
            root_markers = [".git"];
            capabilities = {
              textDocument = {
                semanticTokens = {
                  multilineTokenSupport = true;
                };
              };
            };
          };

          "nixd" = {
            enable = true;
            filetypes = ["nix"];
          };
        };
      };

      # Theme
      vim.theme.enable = true;
      vim.theme.name = "gruvbox";
      vim.theme.style = "dark";

      # Telescope
      vim.telescope = {
        enable = true;
        mappings = {
          lspDocumentSymbols = "<leader>S";
          lspReferences = "gr";
          lspTypeDefinitions = "<leader>gD";
        };
      };

      # Cellular automata
      vim.visuals.cellular-automaton.enable = true;

      # Whichkey
      vim.binds.whichKey.enable = true;

      # Treesitter
      vim.treesitter = {
        enable = true;
        highlight.enable = true;
      };

      # Options
      vim.options = {
        shiftwidth = 2;
        tabstop = 2;
        scrolloff = 8;
      };

      # Languages
      vim.languages = {
        enableFormat = true; # Enable formatting by default
        enableTreesitter = true; # Enable Treesitter by default

        "nix" = {
          enable = true;
          treesitter.enable = true;
        };

        "rust".enable = true;
      };

      vim.extraPlugins = {
        actions-preview = {
          package = pkgs.vimPlugins.actions-preview-nvim;
          setup = "require('actions-preview').setup {}";
        };
      };
    };
  };

  environment.systemPackages = with pkgs; [
    nil
    nixd
    alejandra
  ];
}
